/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class BaseTierWoodenStorageIngredient
extends Ingredient {
    public static final BaseTierWoodenStorageIngredient INSTANCE = new BaseTierWoodenStorageIngredient();

    private BaseTierWoodenStorageIngredient() {
        super(BaseTierWoodenStorageIngredient.getChestsAndBarrels());
    }

    private static Stream<? extends Ingredient.Value> getChestsAndBarrels() {
        Stream<Object> chestsStream = Stream.empty();
        Object object = ModBlocks.CHEST_ITEM.get();
        if (object instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)object;
            ArrayList chestIngredientValues = new ArrayList();
            itemBase.addCreativeTabItems(i -> chestIngredientValues.add(new Ingredient.ItemValue(i)));
            chestsStream = chestIngredientValues.stream();
        }
        Stream<Object> barrelsStream = Stream.empty();
        Object object2 = ModBlocks.BARREL_ITEM.get();
        if (object2 instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)object2;
            ArrayList barrelIngredientValues = new ArrayList();
            itemBase.addCreativeTabItems(i -> barrelIngredientValues.add(new Ingredient.ItemValue(i)));
            barrelsStream = barrelIngredientValues.stream();
        }
        return Stream.concat(chestsStream, barrelsStream);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.m_204117_(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG);
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<BaseTierWoodenStorageIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public BaseTierWoodenStorageIngredient parse(FriendlyByteBuf buffer) {
            return new BaseTierWoodenStorageIngredient();
        }

        public BaseTierWoodenStorageIngredient parse(JsonObject json) {
            return new BaseTierWoodenStorageIngredient();
        }

        public void write(FriendlyByteBuf buffer, BaseTierWoodenStorageIngredient ingredient) {
        }
    }
}

