/*
 * Decompiled with CFR 0.152.
 */
package com.pansmith.steamadditions.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.LargeBoilerRenderer;
import com.gregtechceu.gtceu.common.block.BoilerFireboxType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.pansmith.steamadditions.api.registries.SARegistries;
import it.unimi.dsi.fastutil.ints.Int2LongFunction;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;

public class SAMachines {
    public static final int[] ELECTRIC_TIERS = GTValues.tiersBetween((int)1, (int)(GTCEuAPI.isHighTier() ? 13 : 8));
    public static final int[] LOW_TIERS = GTValues.tiersBetween((int)1, (int)4);
    public static final int[] HIGH_TIERS = GTValues.tiersBetween((int)5, (int)(GTCEuAPI.isHighTier() ? 13 : 9));
    public static final Int2LongFunction defaultTankSizeFunction = tier -> (long)(tier <= 1 ? 8 : (tier == 2 ? 12 : (tier == 3 ? 16 : (tier == 4 ? 32 : 64)))) * FluidHelper.getBucket();
    public static final MachineDefinition STEAM_CENTRIFUGE = SARegistries.REGISTRATE.multiblock("steam_separator", x$0 -> new SteamParallelMultiblockMachine(x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.CASING_BRONZE_BRICKS).recipeType(GTRecipeTypes.CENTRIFUGE_RECIPES).recipeModifier(SteamParallelMultiblockMachine::recipeModifier, true).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", " X "}).aisle(new String[]{"XXX", "X#X", "XXX"}).aisle(new String[]{"XXX", "XSX", " X "}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('#', Predicates.air()).where(' ', Predicates.any()).where('X', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_BRONZE_BRICKS.get()}).setMinGlobalLimited(6).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM_IMPORT_ITEMS}).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM}).setExactLimit(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM_EXPORT_ITEMS}).setPreviewCount(1))).build()).workableCasingRenderer(GTCEu.id((String)"block/casings/solid/machine_casing_bronze_plated_bricks"), GTCEu.id((String)"block/machines/centrifuge"), false).tooltips(new Component[]{Component.m_237115_((String)"block.steamadditions.steam_separator.tooltip")}).register();
    public static final MachineDefinition STEAM_ALLOY_SMELTER = SARegistries.REGISTRATE.multiblock("steam_foundry", x$0 -> new SteamParallelMultiblockMachine(x$0, new Object[0])).rotationState(RotationState.NON_Y_AXIS).appearanceBlock((Supplier)GTBlocks.CASING_BRONZE_BRICKS).recipeType(GTRecipeTypes.ALLOY_SMELTER_RECIPES).recipeModifier(SteamParallelMultiblockMachine::recipeModifier, true).addOutputLimit((RecipeCapability)ItemRecipeCapability.CAP, 1).pattern(definition -> FactoryBlockPattern.start().aisle(new String[]{"FFF", "XXX", "XXX"}).aisle(new String[]{"FFF", "X#X", "XXX"}).aisle(new String[]{"FFF", "XSX", "XXX"}).where('S', Predicates.controller((TraceabilityPredicate)Predicates.blocks((Block[])new Block[]{definition.getBlock()}))).where('F', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.FIREBOX_BRONZE.get()}).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM}).setExactLimit(1))).where('#', Predicates.air()).where(' ', Predicates.any()).where('X', Predicates.blocks((Block[])new Block[]{(Block)GTBlocks.CASING_BRONZE_BRICKS.get()}).setMinGlobalLimited(6).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM_IMPORT_ITEMS}).setPreviewCount(1)).or(Predicates.abilities((PartAbility[])new PartAbility[]{PartAbility.STEAM_EXPORT_ITEMS}).setPreviewCount(1))).build()).renderer(() -> new LargeBoilerRenderer(GTCEu.id((String)"block/casings/solid/machine_casing_bronze_plated_bricks"), BoilerFireboxType.BRONZE_FIREBOX, GTCEu.id((String)"block/machines/alloy_smelter"))).tooltips(new Component[]{Component.m_237115_((String)"block.steamadditions.steam_foundry.tooltip")}).register();

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2LongFunction tankScalingFunction, int ... tiers) {
        return SAMachines.registerTieredMachines(name, (holder, tier) -> new SimpleTieredMachine(holder, tier.intValue(), tankScalingFunction, new Object[0]), (tier, builder) -> builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName((Object)name), GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)name), recipeType)).rotationState(RotationState.NON_Y_AXIS).recipeType(recipeType).recipeModifier((RecipeModifier)GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullRenderer(GTCEu.id((String)("block/machines/" + name))).tooltips(SAMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, (Long)tankScalingFunction.apply(tier), true)).compassNode(name).register(), tiers);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType, Int2LongFunction tankScalingFunction) {
        return SAMachines.registerSimpleMachines(name, recipeType, tankScalingFunction, ELECTRIC_TIERS);
    }

    public static MachineDefinition[] registerSimpleMachines(String name, GTRecipeType recipeType) {
        return SAMachines.registerSimpleMachines(name, recipeType, defaultTankSizeFunction);
    }

    public static MachineDefinition[] registerTieredMachines(String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[tiers.length];
        for (int i = 0; i < tiers.length; ++i) {
            int tier = tiers[i];
            MachineBuilder register = SARegistries.REGISTRATE.machine(GTValues.VN[tier].toLowerCase() + "_" + name, holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[i] = builder.apply(tier, (MachineBuilder<MachineDefinition>)register);
        }
        return definitions;
    }

    public static Component explosion() {
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion) {
            return Component.m_237115_((String)"gtceu.universal.tooltip.terrain_resist");
        }
        return null;
    }

    public static Component[] workableTiered(int tier, long voltage, long energyCapacity, GTRecipeType recipeType, long tankCapacity, boolean input) {
        ArrayList<MutableComponent> tooltipComponents = new ArrayList<MutableComponent>();
        tooltipComponents.add(input ? Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{voltage, GTValues.VNF[tier]}) : Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{voltage, GTValues.VNF[tier]}));
        tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{energyCapacity}));
        if (recipeType.getMaxInputs((RecipeCapability)FluidRecipeCapability.CAP) > 0 || recipeType.getMaxOutputs((RecipeCapability)FluidRecipeCapability.CAP) > 0) {
            tooltipComponents.add(Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{tankCapacity}));
        }
        return (Component[])tooltipComponents.toArray(Component[]::new);
    }

    public static void init() {
    }
}

