/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import me.srrapero720.waterframes.WFConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.Display;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.Util;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class DisplayRenderer
implements BlockEntityRenderer<DisplayTile> {
    private static final Function<ResourceLocation, RenderType> BLOCK_TRANSLUCENT_CULL_CUSTOM_TEXTURE = Util.m_143827_(p_173198_ -> {
        RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173108_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173198_, false, false)).m_110685_(RenderType.f_110139_).m_110671_(RenderType.f_110152_).m_110677_(RenderType.f_110155_).m_110691_(false);
        return RenderType.m_173215_((String)"block_translucent_cull_custom_texture", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
    });
    private final BlockEntityRendererProvider.Context context;

    public DisplayRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public boolean shouldRenderOffScreen(DisplayTile tile) {
        return tile.data.getWidth() > 16.0f || tile.data.getHeight() > 16.0f;
    }

    public boolean shouldRender(DisplayTile tile, @NotNull Vec3 cameraPos) {
        return Vec3.m_82512_((Vec3i)tile.m_58899_()).m_82509_((Position)cameraPos, (double)tile.data.renderDistance);
    }

    public void render(DisplayTile tile, float partialTicks, PoseStack pose, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int b;
        Display display = tile.activeDisplay();
        if (display == null || !WFConfig.keepsRendering()) {
            return;
        }
        Direction direction = tile.getDirection();
        AlignedBox box = tile.getRenderBox();
        boolean invertedFace = tile.caps.invertedFace(tile);
        BoxFace boxFace = BoxFace.get((Facing)Facing.get((Direction)(invertedFace ? direction.m_122424_() : direction)));
        Facing facing = boxFace.facing;
        packedLight = LightTexture.m_109885_((int)15, (int)15);
        boolean front = !tile.caps.projects() || tile.data.renderBothSides;
        boolean back = tile.caps.projects() || tile.data.renderBothSides;
        boolean flipX = tile.caps.projects() != tile.data.flipX;
        boolean flipY = tile.data.flipY;
        int g = b = tile.data.brightness;
        int r = b;
        int a = tile.data.alpha;
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5, 0.5);
        pose.m_252781_(facing.rotation().m_252961_((float)Math.toRadians(-tile.data.rotation)));
        pose.m_85837_(-0.5, -0.5, -0.5);
        if (tile.caps.growMax(tile, facing, invertedFace)) {
            box.setMax(facing.axis, box.getMax(facing.axis) + tile.caps.growSize());
        } else {
            box.setMin(facing.axis, box.getMin(facing.axis) - tile.caps.growSize());
        }
        if (display.isLoading()) {
            this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
        } else if (display.canRender()) {
            int tex = display.texture();
            if (tex != -1) {
                this.vertex(pose, bufferSource, box, boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, display.getTextureId());
            }
            if (display.isBuffering()) {
                this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
            }
        }
        pose.m_85849_();
    }

    public void vertex(PoseStack pose, MultiBufferSource source, AlignedBox box, BoxFace boxface, Facing facing, int packedLight, int packedOverlay, boolean front, boolean back, boolean flipX, boolean flipY, int r, int g, int b, int a, ResourceLocation texture) {
        BoxCorner corner;
        int i;
        VertexConsumer builder = source.m_6299_(BLOCK_TRANSLUCENT_CULL_CUSTOM_TEXTURE.apply(texture));
        if (front) {
            for (i = 0; i < boxface.corners.length; ++i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
        if (back) {
            for (i = boxface.corners.length - 1; i >= 0; --i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
    }

    public void vertex(PoseStack pose, VertexConsumer builder, AlignedBox box, BoxFace boxface, BoxCorner corner, Facing facing, int packedLight, int packedOverlay, boolean flipX, boolean flipY, int r, int g, int b, int a) {
        Vec3i normal = facing.normal;
        builder.m_252986_(pose.m_85850_().m_252922_(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_6122_(r, g, b, a).m_7421_(corner.isFacing(boxface.getTexU()) != flipX ? 1.0f : 0.0f, corner.isFacing(boxface.getTexV()) != flipY ? 1.0f : 0.0f).m_85969_(packedLight).m_86008_(OverlayTexture.f_118083_).m_252939_(pose.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    public AlignedBox getLoadingBox(DisplayTile tile, AlignedBox parent, Facing facing) {
        float height;
        AlignedBox box = new AlignedBox(parent);
        Axis one = facing.one();
        Axis two = facing.two();
        float width = box.getSize(one);
        if (width > (height = box.getSize(two))) {
            float subtracts = (width - height) / 2.0f;
            float marginSubstract = height / 4.0f;
            box.setMin(one, box.getMin(one) + subtracts + marginSubstract);
            box.setMax(one, box.getMax(one) - subtracts - marginSubstract);
            box.setMin(two, box.getMin(two) + marginSubstract);
            box.setMax(two, box.getMax(two) - marginSubstract);
        } else if (height > width) {
            float subtracts = (height - width) / 2.0f;
            float marginSubstract = width / 4.0f;
            box.setMin(two, box.getMin(two) + subtracts + marginSubstract);
            box.setMax(two, box.getMax(two) - subtracts - marginSubstract);
            box.setMin(one, box.getMin(one) + marginSubstract);
            box.setMax(one, box.getMax(one) - marginSubstract);
        }
        if (facing.positive) {
            box.setMax(facing.axis, parent.getMax(facing.axis) + (tile.caps.projects() ? -0.001f : 0.001f));
        } else {
            box.setMin(facing.axis, parent.getMin(facing.axis) - (tile.caps.projects() ? -0.001f : 0.001f));
        }
        return box;
    }
}

