/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.network.packets;

import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.creativecore.common.network.CreativePacket;

public abstract class DisplayControlPacket
extends CreativePacket {
    public BlockPos pos;
    public boolean bounce;

    public DisplayControlPacket() {
    }

    public DisplayControlPacket(BlockPos pos, boolean bounce) {
        this.pos = pos;
        this.bounce = bounce;
    }

    public abstract void execServer(DisplayTile var1);

    public abstract void execClient(DisplayTile var1);

    public abstract void exec(DisplayTile var1);

    public void execute(DisplayTile tile, boolean isClientSide) {
        this.exec(tile);
        if (isClientSide) {
            this.execClient(tile);
        } else {
            this.execServer(tile);
            if (this.bounce) {
                this.bounce = false;
                DisplayNetwork.sendClient(this, tile);
            }
        }
    }

    public void execute(Player player) {
        BlockEntity blockEntity = player.f_19853_.m_7702_(this.pos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            this.execute(tile, player.f_19853_.f_46443_);
        } else {
            WaterFrames.LOGGER.error("Received packet pointing to the invalid DisplayTile position {}", (Object)this.pos);
        }
    }

    @Deprecated
    public void executeClient(Player player) {
        throw new UnsupportedOperationException("No-op");
    }

    @Deprecated
    public void executeServer(ServerPlayer serverPlayer) {
        throw new UnsupportedOperationException("No-op");
    }
}

