/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import zone.rong.mixinbooter.IEarlyMixinLoader;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-2147483647)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.mixinbooter.MixinBooterPlugin$Container";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (coremodList instanceof List) {
            for (Object coremod : (List)coremodList) {
                try {
                    Field field = coremod.getClass().getField("coreModInstance");
                    field.setAccessible(true);
                    Object theMod = field.get(coremod);
                    if (!(theMod instanceof IEarlyMixinLoader)) continue;
                    IEarlyMixinLoader loader = (IEarlyMixinLoader)theMod;
                    for (String mixinConfig : loader.getMixinConfigs()) {
                        if (!loader.shouldMixinConfigQueue(mixinConfig)) continue;
                        LOGGER.info("Adding {} mixin configuration.", (Object)mixinConfig);
                        Mixins.addConfiguration(mixinConfig);
                        loader.onMixinConfigQueued(mixinConfig);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        LOGGER.info("MixinBootstrap Initializing...");
        MixinBootstrap.init();
        Mixins.addConfiguration("mixin.mixinbooter.init.json");
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            ModMetadata meta = this.getMetadata();
            meta.modId = "mixinbooter";
            meta.name = "MixinBooter";
            meta.description = "A library mod that helps out modders that want to mixin into mods but couldn't as they weren't inherently coremods.";
            meta.version = "4.2";
            meta.logoFile = "/icon.png";
            meta.authorList.add("Rongmario");
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }
    }
}

