/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.util;

import codechicken.lib.util.ItemUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemMatterCluster;
import morph.avaritia.util.ItemStackWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public class ToolHelper {
    public static Material[] materialsPick = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g};
    public static Material[] materialsShovel = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    public static Set<Material> materialsAxe = Sets.newHashSet((Object[])new Material[]{Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151582_l});

    public static void aoeBlocks(EntityPlayer player, ItemStack stack, World world, BlockPos origin, BlockPos min, BlockPos max, Block target, Set<Material> validMaterials, boolean filterTrash) {
        AvaritiaEventHandler.enableItemCapture();
        for (int lx = min.func_177958_n(); lx < max.func_177958_n(); ++lx) {
            for (int ly = min.func_177956_o(); ly < max.func_177956_o(); ++ly) {
                for (int lz = min.func_177952_p(); lz < max.func_177952_p(); ++lz) {
                    BlockPos pos = origin.func_177982_a(lx, ly, lz);
                    ToolHelper.removeBlockWithDrops(player, stack, world, pos, target, validMaterials);
                }
            }
        }
        AvaritiaEventHandler.stopItemCapture();
        Set<ItemStack> drops = AvaritiaEventHandler.getCapturedDrops();
        if (filterTrash) {
            drops = ToolHelper.removeTrash(stack, drops);
        }
        if (!world.field_72995_K) {
            List<ItemStack> clusters = ItemMatterCluster.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                ItemUtils.dropItem((World)world, (BlockPos)origin, (ItemStack)cluster);
            }
        }
    }

    public static void removeBlockWithDrops(EntityPlayer player, ItemStack stack, World world, BlockPos pos, Block target, Set<Material> validMaterials) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K) {
            if (target != null && target != state.func_177230_c() || block.isAir(state, (IBlockAccess)world, pos)) {
                return;
            }
            Material material = state.func_185904_a();
            if (block == Blocks.field_150349_c && stack.func_77973_b() == ModItems.infinity_axe) {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            }
            if (!block.canHarvestBlock((IBlockAccess)world, pos, player) || !validMaterials.contains(material)) {
                return;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    TileEntity tile = world.func_175625_s(pos);
                    block.func_176208_a(world, pos, state, player);
                    if (block.removedByPlayer(state, world, pos, player, true)) {
                        block.func_176206_d(world, pos, state);
                        block.func_180657_a(world, player, pos, state, tile, stack);
                    }
                } else {
                    world.func_175698_g(pos);
                }
            }
        }
    }

    public static Set<ItemStack> removeTrash(ItemStack holdingStack, Set<ItemStack> drops) {
        HashSet<ItemStack> trashItems = new HashSet<ItemStack>();
        for (ItemStack drop : drops) {
            if (!ToolHelper.isTrash(holdingStack, drop)) continue;
            trashItems.add(drop);
        }
        drops.removeAll(trashItems);
        return drops;
    }

    private static boolean isTrash(ItemStack holdingStack, ItemStack suspect) {
        boolean isTrash = false;
        for (int id : OreDictionary.getOreIDs((ItemStack)suspect)) {
            for (String ore : AvaritiaEventHandler.defaultTrashOres) {
                if (!OreDictionary.getOreName((int)id).equals(ore)) continue;
                return true;
            }
        }
        return isTrash;
    }

    public static List<ItemStack> collateDropList(Set<ItemStack> input) {
        return ToolHelper.collateMatterClusterContents(ToolHelper.collateMatterCluster(input));
    }

    public static List<ItemStack> collateMatterClusterContents(Map<ItemStackWrapper, Integer> input) {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStackWrapper, Integer> e : input.entrySet()) {
            int count = e.getValue();
            ItemStackWrapper wrap = e.getKey();
            int size = wrap.stack.func_77976_d();
            int fullstacks = (int)Math.floor(count / size);
            for (int i = 0; i < fullstacks; ++i) {
                count -= size;
                ItemStack stack = wrap.stack.func_77946_l();
                stack.func_190920_e(size);
                collated.add(stack);
            }
            if (count <= 0) continue;
            ItemStack stack = wrap.stack.func_77946_l();
            stack.func_190920_e(count);
            collated.add(stack);
        }
        return collated;
    }

    public static Map<ItemStackWrapper, Integer> collateMatterCluster(Set<ItemStack> input) {
        HashMap<ItemStackWrapper, Integer> counts = new HashMap<ItemStackWrapper, Integer>();
        if (input != null) {
            for (ItemStack stack : input) {
                ItemStackWrapper wrap = new ItemStackWrapper(stack);
                if (!counts.containsKey(wrap)) {
                    counts.put(wrap, 0);
                }
                counts.put(wrap, (Integer)counts.get(wrap) + stack.func_190916_E());
            }
        }
        return counts;
    }
}

