/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.advancement.AdvListenerManager;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.events.MarkDirtyPlayerEvent;
import betterquesting.api.events.QuestEvent;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNone;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuestLines;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.commands.client.QuestCommandShow;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.LootSaveLoad;
import betterquesting.handlers.PlayerContainerListener;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.handlers.NetBulkSync;
import betterquesting.network.handlers.NetLootSync;
import betterquesting.network.handlers.NetNameSync;
import betterquesting.network.handlers.NetNotices;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetTaskInteract;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.questing.tasks.ITaskTickable;
import betterquesting.questing.tasks.TaskAdvancement;
import betterquesting.questing.tasks.TaskBlockBreak;
import betterquesting.questing.tasks.TaskCrafting;
import betterquesting.questing.tasks.TaskHunt;
import betterquesting.questing.tasks.TaskInteractEntity;
import betterquesting.questing.tasks.TaskInteractItem;
import betterquesting.questing.tasks.TaskTame;
import betterquesting.questing.tasks.TaskTrigger;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();
    private static final String SPAWN_WITH_QUEST_BOOK = "betterquesting.questbook";
    private final ArrayDeque<EntityPlayerMP> opQueue = new ArrayDeque();
    private boolean openToLAN = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && BQ_Keybindings.openQuests.func_151468_f()) {
            if (BQ_Settings.useBookmark && GuiHome.bookmark != null) {
                mc.func_147108_a(GuiHome.bookmark);
            } else {
                GuiScreen guiToDisplay = ThemeRegistry.INSTANCE.getGui(PresetGUIs.HOME, GArgsNone.NONE);
                if (BQ_Settings.useBookmark && BQ_Settings.skipHome) {
                    guiToDisplay = new GuiQuestLines(guiToDisplay);
                }
                mc.func_147108_a(guiToDisplay);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        String text;
        int index;
        if (event.getMessage() != null && (index = (text = event.getMessage().func_150254_d()).indexOf("betterquesting.msg.share_quest:")) != -1) {
            Style newMessageStyle;
            int digit;
            int lastIndex;
            int endIndex = lastIndex = index + "betterquesting.msg.share_quest:".length();
            int questId = 0;
            for (int i = lastIndex; i < text.length() && (digit = Character.getNumericValue(text.charAt(i))) >= 0; ++i) {
                ++endIndex;
                questId = questId * 10 + digit;
            }
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(questId);
            if (quest == null) {
                event.setMessage((ITextComponent)new TextComponentTranslation("betterquesting.msg.share_quest_invalid", new Object[]{String.valueOf(questId)}));
                return;
            }
            String questName = quest.getProperty(NativeProps.NAME);
            TextComponentTranslation translated = new TextComponentTranslation("betterquesting.msg.share_quest", new Object[]{questId, questName});
            TextComponentString newMessage = new TextComponentString(text.substring(0, index) + translated.func_150254_d() + text.substring(endIndex));
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (QuestCache.isQuestShown(quest, QuestingAPI.getQuestingUUID((EntityPlayer)player), (EntityPlayer)player)) {
                QuestCommandShow.sentViaClick = true;
                newMessageStyle = newMessage.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/bq_client show " + questId)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("betterquesting.msg.share_quest_hover_text_success", new Object[0])));
            } else {
                newMessageStyle = newMessage.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("betterquesting.msg.share_quest_hover_text_failure", new Object[0])));
            }
            event.setMessage(newMessage.func_150255_a(newMessageStyle));
        }
    }

    @SubscribeEvent
    public void onCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(CapabilityProviderQuestCache.LOC_QUEST_CACHE, (ICapabilityProvider)new CapabilityProviderQuestCache());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        QuestCache oCache = (QuestCache)event.getOriginal().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        QuestCache nCache = (QuestCache)event.getEntityPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (oCache != null && nCache != null) {
            nCache.deserializeNBT(oCache.serializeNBT());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        if (event.getEntityLiving().field_70173_aa % 20 != 0) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
        if (qc == null) {
            return;
        }
        List activeQuests = QuestDatabase.INSTANCE.bulkLookup(qc.getActiveQuests());
        List pendingAutoClaims = QuestDatabase.INSTANCE.bulkLookup(qc.getPendingAutoClaims());
        QuestCache.QResetTime[] pendingResets = qc.getScheduledResets();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        boolean refreshCache = false;
        if (!editMode && player.field_70173_aa % 60 == 0) {
            ArrayList<Integer> com = new ArrayList<Integer>();
            for (DBEntry quest : activeQuests) {
                DBEntry<IParty> partyEntry;
                if (!((IQuest)quest.getValue()).isUnlocked(uuid)) continue;
                if (((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) {
                    ((IQuest)quest.getValue()).update((EntityPlayer)player);
                }
                if (!((IQuest)quest.getValue()).isComplete(uuid) || ((IQuest)quest.getValue()).canSubmit((EntityPlayer)player)) continue;
                refreshCache = true;
                qc.markQuestDirty(quest.getID());
                com.add(quest.getID());
                if (!((IQuest)quest.getValue()).getProperty(NativeProps.SILENT).booleanValue()) {
                    EventHandler.postPresetNotice((IQuest)quest.getValue(), (EntityPlayer)player, 2);
                }
                if ((partyEntry = PartyManager.INSTANCE.getParty(uuid)) == null || player.func_184102_h() == null) continue;
                for (UUID memID : partyEntry.getValue().getMembers()) {
                    EntityPlayerMP memPlayer = player.func_184102_h().func_184103_al().func_152612_a(NameCache.INSTANCE.getName(memID));
                    if (memPlayer == null) continue;
                    ((IQuest)quest.getValue()).detect((EntityPlayer)memPlayer);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.COMPLETED, uuid, com));
        }
        if (!editMode && player.func_184102_h() != null) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            long totalTime = System.currentTimeMillis();
            for (QuestCache.QResetTime rTime : pendingResets) {
                IQuest entry = (IQuest)QuestDatabase.INSTANCE.getValue(rTime.questID);
                if (totalTime < rTime.time || entry.canSubmit((EntityPlayer)player)) break;
                if (entry.getProperty(NativeProps.GLOBAL).booleanValue()) {
                    entry.resetUser(null, false);
                } else {
                    entry.resetUser(uuid, false);
                }
                refreshCache = true;
                qc.markQuestDirty(rTime.questID);
                res.add(rTime.questID);
                if (entry.getProperty(NativeProps.SILENT).booleanValue()) continue;
                EventHandler.postPresetNotice(entry, (EntityPlayer)player, 1);
            }
            MinecraftForge.EVENT_BUS.post((Event)new QuestEvent(QuestEvent.Type.RESET, uuid, res));
        }
        if (!editMode) {
            for (DBEntry entry : pendingAutoClaims) {
                if (!((IQuest)entry.getValue()).canClaim((EntityPlayer)player)) continue;
                ((IQuest)entry.getValue()).claimReward((EntityPlayer)player);
                refreshCache = true;
                qc.markQuestDirty(entry.getID());
            }
        }
        if (refreshCache || player.field_70173_aa % 200 == 0) {
            qc.updateCache((EntityPlayer)player);
        }
        if (qc.getDirtyQuests().length > 0) {
            NetQuestSync.sendSync(player, qc.getDirtyQuests(), false, true);
        }
        qc.cleanAllQuests();
    }

    private static void postPresetNotice(IQuest quest, EntityPlayer player, int preset) {
        EntityPlayerMP[] entityPlayerMPArray;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack icon = quest.getProperty(NativeProps.ICON).getBaseStack();
        String mainText = "";
        String subText = quest.getProperty(NativeProps.NAME);
        String sound = "";
        switch (preset) {
            case 0: {
                mainText = "betterquesting.notice.unlock";
                sound = quest.getProperty(NativeProps.SOUND_UNLOCK);
                break;
            }
            case 1: {
                mainText = "betterquesting.notice.update";
                sound = quest.getProperty(NativeProps.SOUND_UPDATE);
                break;
            }
            case 2: {
                mainText = "betterquesting.notice.complete";
                sound = quest.getProperty(NativeProps.SOUND_COMPLETE);
            }
        }
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            entityPlayerMPArray = null;
        } else {
            EntityPlayerMP[] entityPlayerMPArray2 = new EntityPlayerMP[1];
            entityPlayerMPArray = entityPlayerMPArray2;
            entityPlayerMPArray2[0] = (EntityPlayerMP)player;
        }
        NetNotices.sendNotice(entityPlayerMPArray, icon, mainText, subText, sound);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            if (BQ_Settings.curWorldDir != null) {
                SaveLoadHandler.INSTANCE.saveDatabases();
            }
            if (LootSaveLoad.INSTANCE.worldDir != null) {
                LootSaveLoad.INSTANCE.SaveLoot();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (BQ_Settings.spawnWithQuestBook) {
            NBTTagCompound data;
            NBTTagCompound playerData = event.player.getEntityData();
            NBTTagCompound nBTTagCompound = data = playerData.func_74764_b("PlayerPersisted") ? playerData.func_74775_l("PlayerPersisted") : new NBTTagCompound();
            if (!data.func_74767_n(SPAWN_WITH_QUEST_BOOK)) {
                ItemStack questBook = new ItemStack(BetterQuesting.questBook);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)questBook);
                data.func_74757_a(SPAWN_WITH_QUEST_BOOK, true);
                playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
            }
        }
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            NetLootSync.sendSync((EntityPlayerMP)event.player);
        }
        if (event.player.field_70170_p.field_72995_K || event.player.func_184102_h() == null || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
        if (BetterQuesting.proxy.isClient() && !mpPlayer.func_184102_h().func_71262_S() && event.player.func_184102_h().func_71214_G().equals(mpPlayer.func_146103_bH().getName())) {
            NameCache.INSTANCE.updateName(mpPlayer);
            return;
        }
        NetBulkSync.sendReset(mpPlayer, true, true);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            int lives = LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            if (lives <= 0) {
                MinecraftServer server = mpPlayer.func_184102_h();
                if (server == null) {
                    return;
                }
                mpPlayer.func_71033_a(GameType.SPECTATOR);
                if (!server.func_71262_S()) {
                    mpPlayer.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
                }
            } else if (lives == 1) {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString("This is your last life!"), true);
            } else {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString(lives + " lives remaining!"), true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.getEntityLiving());
            int lives = LifeDatabase.INSTANCE.getLives(uuid);
            LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(FluidPlaceholder.fluidPlaceholder.getStill());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            Minecraft.func_71410_x().func_152344_a(((INeedsRefresh)screen)::refreshGui);
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        EntityPlayerMP playerMP;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (event.getCommand().func_71517_b().equalsIgnoreCase("op") || event.getCommand().func_71517_b().equalsIgnoreCase("deop")) && (playerMP = server.func_184103_al().func_152612_a(event.getParameters()[0])) != null) {
            this.opQueue.add(playerMP);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 60 == 0) {
            AdvListenerManager.INSTANCE.updateAll();
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!server.func_71262_S()) {
            boolean tmp = this.openToLAN;
            boolean bl = this.openToLAN = server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
            if (this.openToLAN && !tmp) {
                this.opQueue.addAll(server.func_184103_al().func_181057_v());
            }
        } else if (!this.openToLAN) {
            this.openToLAN = true;
        }
        while (!this.opQueue.isEmpty()) {
            EntityPlayerMP playerMP = this.opQueue.poll();
            if (playerMP == null || !NameCache.INSTANCE.updateName(playerMP)) continue;
            DBEntry<IParty> party = PartyManager.INSTANCE.getParty(QuestingAPI.getQuestingUUID((EntityPlayer)playerMP));
            if (party != null) {
                NetNameSync.quickSync(null, party.getID());
                continue;
            }
            NetNameSync.sendNames(new EntityPlayerMP[]{playerMP}, new UUID[]{QuestingAPI.getQuestingUUID((EntityPlayer)playerMP)}, null);
        }
        if (server.func_71259_af() % 60 == 0) {
            PartyInvitations.INSTANCE.cleanExpired();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, dBEntry, event.getHand(), event.getItemStack(), Blocks.field_150350_a.func_176223_P(), event.getPos(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        IBlockState state = player.field_70170_p.func_180495_p(event.getPos());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, dBEntry, event.getHand(), event.getItemStack(), state, event.getPos(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        IBlockState state = player.field_70170_p.func_180495_p(event.getPos());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract(pInfo, dBEntry, event.getHand(), event.getItemStack(), state, event.getPos(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getEntityPlayer() == null || !event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        NetTaskInteract.requestInteraction(false, event.getHand() == EnumHand.MAIN_HAND);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntityPlayer() == null || !event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        NetTaskInteract.requestInteraction(true, true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAttack(AttackEntityEvent event) {
        if (event.getEntityPlayer() == null || event.getTarget() == null || event.getEntityPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract(pInfo, dBEntry, EnumHand.MAIN_HAND, player.func_184614_ca(), event.getTarget(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer() == null || event.getTarget() == null || event.getEntityPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract(pInfo, dBEntry, event.getHand(), event.getItemStack(), event.getTarget(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemCraft(pInfo, dBEntry, event.crafting.func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemSmelt(pInfo, dBEntry, event.smelting.func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemAnvil(AnvilRepairEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.getEntityPlayer());
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemAnvil(pInfo, dBEntry, event.getItemResult().func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)event.getSource().func_76346_g());
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskHunt)) continue;
                ((TaskHunt)task.getValue()).onKilledByPlayer(pInfo, dBEntry, event.getEntityLiving(), event.getSource());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTamed(AnimalTameEvent event) {
        if (event.getTamer() == null || event.getTamer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getTamer();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        for (DBEntry<IQuest> dBEntry : QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskTame)) continue;
                ((TaskTame)task.getValue()).onAnimalTamed(pInfo, dBEntry, event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.getPlayer());
        for (DBEntry<IQuest> dBEntry : QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskBlockBreak)) continue;
                ((TaskBlockBreak)task.getValue()).onBlockBreak(pInfo, dBEntry, event.getState(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving().field_70173_aa % 20 != 0 || QuestingAPI.getAPI(ApiReference.SETTINGS).getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List actQuest = QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests());
        for (DBEntry<IQuest> dBEntry : actQuest) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (task.getValue() instanceof ITaskTickable) {
                    ((ITaskTickable)task.getValue()).tickTask(pInfo, dBEntry);
                    continue;
                }
                if (!(task.getValue() instanceof TaskTrigger)) continue;
                ((TaskTrigger)task.getValue()).checkSetup(player, dBEntry);
            }
        }
    }

    @SubscribeEvent
    public void onAdvancement(AdvancementEvent event) {
        if (event.getEntityPlayer() == null || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo(event.getEntityPlayer());
        for (DBEntry<IQuest> dBEntry : QuestingAPI.getAPI(ApiReference.QUEST_DB).bulkLookup(pInfo.getSharedQuests())) {
            for (DBEntry task : ((IQuest)dBEntry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskAdvancement)) continue;
                ((TaskAdvancement)task.getValue()).onAdvancementGet(dBEntry, pInfo, event.getAdvancement());
            }
        }
    }

    @SubscribeEvent
    public void onEntityCreated(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerContainerListener.refreshListener((EntityPlayer)event.getEntity());
    }

    @SubscribeEvent
    public void onMarkDirtyPlayer(MarkDirtyPlayerEvent event) {
        SaveLoadHandler.INSTANCE.addDirtyPlayers(event.getDirtyPlayerIDs());
    }
}

