/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.XPHelper;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.client.gui2.tasks.PanelTaskXP;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.tasks.ITaskTickable;
import betterquesting.questing.tasks.factory.FactoryTaskXP;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskXP
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private final HashMap<UUID, Long> userProgress = new HashMap();
    public boolean levels = true;
    public int amount = 30;
    public boolean consume = true;

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskXP.INSTANCE.getRegistryName();
    }

    @Override
    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    @Override
    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        long nxtProg;
        if (this.consume || pInfo.PLAYER.field_70173_aa % 60 != 0) {
            return;
        }
        long curProg = this.getUsersProgress(pInfo.UUID);
        if (curProg != (nxtProg = XPHelper.getPlayerXP(pInfo.PLAYER))) {
            this.setUserProgress(pInfo.UUID, XPHelper.getPlayerXP(pInfo.PLAYER));
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
        long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
        long totalXP = this.getUsersProgress(pInfo.UUID);
        if (totalXP >= rawXP) {
            this.setComplete(pInfo.UUID);
        }
    }

    @Override
    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        long progress = this.getUsersProgress(pInfo.UUID);
        long rawXP = this.levels ? XPHelper.getLevelXP(this.amount) : (long)this.amount;
        long plrXP = XPHelper.getPlayerXP(pInfo.PLAYER);
        long remaining = rawXP - progress;
        long cost = Math.min(remaining, plrXP);
        boolean changed = false;
        if (this.consume && cost != 0L) {
            this.setUserProgress(pInfo.UUID, progress += cost);
            XPHelper.addXP(pInfo.PLAYER, -cost);
            changed = true;
        } else if (!this.consume && progress != plrXP) {
            this.setUserProgress(pInfo.UUID, plrXP);
            changed = true;
        }
        long totalXP = this.getUsersProgress(pInfo.UUID);
        if (totalXP >= rawXP) {
            this.setComplete(pInfo.UUID);
            changed = true;
        }
        if (changed) {
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.xp";
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74768_a("amount", this.amount);
        json.func_74757_a("isLevels", this.levels);
        json.func_74757_a("consume", this.consume);
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound json) {
        this.amount = json.func_150297_b("amount", 99) ? json.func_74762_e("amount") : 30;
        this.levels = json.func_74767_n("isLevels");
        this.consume = json.func_74767_n("consume");
    }

    @Override
    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74763_f("value"));
                continue;
            }
            catch (Exception e) {
                BetterQuesting.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Long data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74772_a("value", data.longValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74772_a("value", data.longValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    @Override
    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Override
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskXP(rect, this);
    }

    @Override
    public GuiScreen getTaskEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }

    private void setUserProgress(UUID uuid, long progress) {
        this.userProgress.put(uuid, progress);
    }

    public long getUsersProgress(UUID uuid) {
        Long n = this.userProgress.get(uuid);
        return n == null ? 0L : n;
    }

    @Override
    public boolean displaysCenteredAlone() {
        return true;
    }
}

