/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCubeObject
extends CubeObject {
    public Block block;
    public int meta = 0;
    public int color = -1;
    public Object customData = null;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    private EnumSideRender renderEast = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderWest = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderUp = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderDown = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderSouth = EnumSideRender.INSIDE_RENDERED;
    private EnumSideRender renderNorth = EnumSideRender.INSIDE_RENDERED;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;
    public boolean doesNeedQuadUpdate = true;
    public boolean isEmissive = false;

    public void setQuad(EnumFacing facing, List<BakedQuad> quads) {
        BakedQuad quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public int getQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public RenderCubeObject(CubeObject cube, RenderCubeObject cube2) {
        super(cube);
        this.applyExtraCubeData(cube2);
    }

    public RenderCubeObject(CubeObject cube, Block block, int meta) {
        super(cube);
        this.block = block;
        this.meta = meta;
    }

    public RenderCubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
    }

    public RenderCubeObject(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Block block, int meta) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.block = block;
        this.meta = meta;
    }

    @Override
    protected void applyExtraCubeData(CubeObject cube) {
        if (cube instanceof RenderCubeObject) {
            this.block = ((RenderCubeObject)cube).block;
            this.meta = ((RenderCubeObject)cube).meta;
            this.color = ((RenderCubeObject)cube).color;
            this.renderEast = ((RenderCubeObject)cube).renderEast;
            this.renderWest = ((RenderCubeObject)cube).renderWest;
            this.renderUp = ((RenderCubeObject)cube).renderUp;
            this.renderDown = ((RenderCubeObject)cube).renderDown;
            this.renderSouth = ((RenderCubeObject)cube).renderSouth;
            this.renderNorth = ((RenderCubeObject)cube).renderNorth;
        }
    }

    public RenderCubeObject setColor(Vec3i color) {
        this.setColor(ColorUtils.RGBToInt(color));
        return this;
    }

    public RenderCubeObject setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderCubeObject setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public IBlockState getModelState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.block.getExtendedState(state, world, pos);
    }

    public IBlockState getBlockState() {
        if (this.meta != -1) {
            return BlockUtils.getState(this.block, this.meta);
        }
        return this.block.func_176223_P();
    }

    public IBlockState getBlockState(Block block) {
        if (this.meta != -1) {
            return BlockUtils.getState(block, this.meta);
        }
        return block.func_176223_P();
    }

    public void setSideRender(EnumFacing facing, EnumSideRender renderer) {
        switch (facing) {
            case DOWN: {
                this.renderDown = renderer;
                break;
            }
            case EAST: {
                this.renderEast = renderer;
                break;
            }
            case NORTH: {
                this.renderNorth = renderer;
                break;
            }
            case SOUTH: {
                this.renderSouth = renderer;
                break;
            }
            case UP: {
                this.renderUp = renderer;
                break;
            }
            case WEST: {
                this.renderWest = renderer;
            }
        }
    }

    public EnumSideRender getSidedRendererType(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown;
            }
            case EAST: {
                return this.renderEast;
            }
            case NORTH: {
                return this.renderNorth;
            }
            case SOUTH: {
                return this.renderSouth;
            }
            case UP: {
                return this.renderUp;
            }
            case WEST: {
                return this.renderWest;
            }
        }
        return EnumSideRender.INSIDE_RENDERED;
    }

    public boolean shouldSideBeRendered(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return this.renderDown.shouldBeRendered;
            }
            case EAST: {
                return this.renderEast.shouldBeRendered;
            }
            case NORTH: {
                return this.renderNorth.shouldBeRendered;
            }
            case SOUTH: {
                return this.renderSouth.shouldBeRendered;
            }
            case UP: {
                return this.renderUp.shouldBeRendered;
            }
            case WEST: {
                return this.renderWest.shouldBeRendered;
            }
        }
        return true;
    }

    public boolean intersectsWithFace(EnumFacing facing, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, BlockPos offset) {
        switch (facing.func_176740_k()) {
            case X: {
                return maxY > this.minY - (float)offset.func_177956_o() && minY < this.maxY - (float)offset.func_177956_o() && maxZ > this.minZ - (float)offset.func_177952_p() && minZ < this.maxZ - (float)offset.func_177952_p();
            }
            case Y: {
                return maxX > this.minX - (float)offset.func_177958_n() && minX < this.maxX - (float)offset.func_177958_n() && maxZ > this.minZ - (float)offset.func_177952_p() && minZ < this.maxZ - (float)offset.func_177952_p();
            }
            case Z: {
                return maxX > this.minX - (float)offset.func_177958_n() && minX < this.maxX - (float)offset.func_177958_n() && maxY > this.minY - (float)offset.func_177956_o() && minY < this.maxY - (float)offset.func_177956_o();
            }
        }
        return false;
    }

    protected List<BakedQuad> getBakedQuad(IBlockAccess world, IBakedModel blockModel, IBlockState state, EnumFacing facing, BlockPos pos, BlockRenderLayer layer, long rand) {
        return OptifineHelper.getRenderQuads(blockModel.func_188616_a(state, facing, rand), world, state, pos, facing, layer, rand);
    }

    public List<BakedQuad> getBakedQuad(IBlockAccess world, @Nullable BlockPos pos, BlockPos offset, IBlockState state, IBakedModel blockModel, EnumFacing facing, BlockRenderLayer layer, long rand, boolean overrideTint, int defaultColor) {
        List<BakedQuad> blockQuads = this.getBakedQuad(world, blockModel, state, facing, pos, layer, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        int color = this.color != -1 ? this.color : defaultColor;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            float sizeV;
            float sizeU;
            BakedQuad oldQuad = blockQuads.get(i);
            if (!this.isEmissive && OptifineHelper.isEmissive(oldQuad.func_187508_a())) {
                this.isEmissive = true;
            }
            int index = 0;
            int uvIndex = index + oldQuad.getFormat().func_177344_b(0) / 4;
            float tempMinX = Float.intBitsToFloat(oldQuad.func_178209_a()[index]);
            float tempMinY = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]);
            float tempMinZ = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 2]);
            float tempU = Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]);
            float tempV = Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex + 1]);
            boolean uvInverted = false;
            index = 1 * oldQuad.getFormat().func_181719_f();
            uvIndex = index + oldQuad.getFormat().func_177344_b(0) / 4;
            uvInverted = tempMinX != Float.intBitsToFloat(oldQuad.func_178209_a()[index]) ? (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.X != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.X != RotationUtils.getVAxisFromFacing(facing)) : (tempMinY != Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]) ? (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.Y != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.Y != RotationUtils.getVAxisFromFacing(facing)) : (tempU != Float.intBitsToFloat(oldQuad.func_178209_a()[uvIndex]) ? EnumFacing.Axis.Z != RotationUtils.getUAxisFromFacing(facing) : EnumFacing.Axis.Z != RotationUtils.getVAxisFromFacing(facing)));
            index = 2 * oldQuad.getFormat().func_181719_f();
            float tempMaxX = Float.intBitsToFloat(oldQuad.func_178209_a()[index]);
            float tempMaxY = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(oldQuad.func_178209_a()[index + 2]);
            float minX = Math.min(tempMinX, tempMaxX);
            float minY = Math.min(tempMinY, tempMaxY);
            float minZ = Math.min(tempMinZ, tempMaxZ);
            float maxX = Math.max(tempMinX, tempMaxX);
            float maxY = Math.max(tempMinY, tempMaxY);
            float maxZ = Math.max(tempMinZ, tempMaxZ);
            if (!this.intersectsWithFace(facing, minX, minY, minZ, maxX, maxY, maxZ, offset)) continue;
            float sizeX = maxX - minX;
            float sizeY = maxY - minY;
            float sizeZ = maxZ - minZ;
            CreativeBakedQuad quad = new CreativeBakedQuad(blockQuads.get(i), this, color, overrideTint && (defaultColor == -1 || blockQuads.get(i).func_178212_b()) && color != -1, facing);
            uvIndex = quad.getFormat().func_177344_b(0) / 4;
            float u1 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex]);
            float v1 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]);
            uvIndex = 2 * quad.getFormat().func_181719_f() + quad.getFormat().func_177344_b(0) / 4;
            float u2 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex]);
            float v2 = Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]);
            if (uvInverted) {
                sizeU = RotationUtils.getVFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getVFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                sizeV = RotationUtils.getUFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getUFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                sizeU = RotationUtils.getUFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getUFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                sizeV = RotationUtils.getVFromFacing(facing, tempMinX, tempMinY, tempMinZ) < RotationUtils.getVFromFacing(facing, tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            EnumFaceDirection direction = EnumFaceDirection.func_179027_a((EnumFacing)facing);
            for (int k = 0; k < 4; ++k) {
                float vOffset;
                float uOffset;
                EnumFaceDirection.VertexInformation vertex = direction.func_179025_a(k);
                index = k * quad.getFormat().func_181719_f();
                float x = facing.func_176740_k() == EnumFacing.Axis.X || this.allowOverlap ? this.getVertexInformationPosition(vertex.field_179184_a) - (float)offset.func_177958_n() : MathHelper.func_76131_a((float)(this.getVertexInformationPosition(vertex.field_179184_a) - (float)offset.func_177958_n()), (float)minX, (float)maxX);
                float y = facing.func_176740_k() == EnumFacing.Axis.Y || this.allowOverlap ? this.getVertexInformationPosition(vertex.field_179182_b) - (float)offset.func_177956_o() : MathHelper.func_76131_a((float)(this.getVertexInformationPosition(vertex.field_179182_b) - (float)offset.func_177956_o()), (float)minY, (float)maxY);
                float z = facing.func_176740_k() == EnumFacing.Axis.Z || this.allowOverlap ? this.getVertexInformationPosition(vertex.field_179183_c) - (float)offset.func_177952_p() : MathHelper.func_76131_a((float)(this.getVertexInformationPosition(vertex.field_179183_c) - (float)offset.func_177952_p()), (float)minZ, (float)maxZ);
                float oldX = Float.intBitsToFloat(quad.func_178209_a()[index]);
                float oldY = Float.intBitsToFloat(quad.func_178209_a()[index + 1]);
                float oldZ = Float.intBitsToFloat(quad.func_178209_a()[index + 2]);
                quad.func_178209_a()[index] = Float.floatToIntBits(x + (float)offset.func_177958_n());
                quad.func_178209_a()[index + 1] = Float.floatToIntBits(y + (float)offset.func_177956_o());
                quad.func_178209_a()[index + 2] = Float.floatToIntBits(z + (float)offset.func_177952_p());
                if (this.keepVU) continue;
                uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
                if (uvInverted) {
                    uOffset = (RotationUtils.getVFromFacing(facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(facing, x, y, z)) / RotationUtils.getVFromFacing(facing, sizeX, sizeY, sizeZ) * sizeU;
                    vOffset = (RotationUtils.getUFromFacing(facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(facing, x, y, z)) / RotationUtils.getUFromFacing(facing, sizeX, sizeY, sizeZ) * sizeV;
                } else {
                    uOffset = (RotationUtils.getUFromFacing(facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(facing, x, y, z)) / RotationUtils.getUFromFacing(facing, sizeX, sizeY, sizeZ) * sizeU;
                    vOffset = (RotationUtils.getVFromFacing(facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(facing, x, y, z)) / RotationUtils.getVFromFacing(facing, sizeX, sizeY, sizeZ) * sizeV;
                }
                quad.func_178209_a()[uvIndex] = Float.floatToRawIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]) - uOffset);
                quad.func_178209_a()[uvIndex + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]) - vOffset);
            }
            quads.add(quad);
        }
        return quads;
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    public static enum EnumSideRender {
        INSIDE_RENDERED(true, false),
        INSIDE_NOT_RENDERED(false, false),
        OUTSIDE_RENDERED(true, true),
        OUTSIDE_NOT_RENDERD(false, true);

        public final boolean shouldBeRendered;
        public final boolean outside;

        private EnumSideRender(boolean shouldBeRendered, boolean outside) {
            this.shouldBeRendered = shouldBeRendered;
            this.outside = outside;
        }
    }
}

