/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.controls.gui.GuiClickableLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.Color;

public class GuiComboBoxExtensionCategory<T>
extends GuiScrollBox {
    public GuiComboBoxCategory<T> comboBox;
    public Pair<String, T> selected;

    public GuiComboBoxExtensionCategory(String name, GuiComboBoxCategory<T> comboBox, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.comboBox = comboBox;
        this.selected = comboBox.getSelected();
        this.reloadControls();
    }

    @Override
    public Vec3d getCenterOffset() {
        return new Vec3d((double)(this.width / 2), (double)(-this.comboBox.height / 2), 0.0);
    }

    @Override
    public void onLoseFocus() {
        if (!this.comboBox.isMouseOver() && !this.isMouseOver()) {
            this.comboBox.closeBox();
        }
    }

    public void reloadControls() {
        this.controls.clear();
        int index = 0;
        int height = 0;
        for (Pair pair : this.comboBox.elements) {
            if (pair.key != null && !((String)pair.key).isEmpty()) {
                this.controls.add(new GuiLabel((String)pair.key, ChatFormatting.UNDERLINE + "" + ChatFormatting.ITALIC + GuiComboBoxExtensionCategory.translate((String)pair.key), 0, height));
                height += 15;
            }
            for (Pair pair2 : (PairList)pair.value) {
                int color = 0xE0E0E0;
                if (pair2 == this.selected) {
                    color = 0xFFFF28;
                }
                final int itemIndex = index++;
                GuiClickableLabel label = new GuiClickableLabel((String)pair2.key, GuiComboBoxExtensionCategory.translate((String)pair2.key), 0, height, this.width - this.scrollbarWidth - 2 - this.getContentOffset() * 2, 8, color){

                    @Override
                    public int getColor() {
                        if (this.isMouseOver() && this.color != 0xFFFF28) {
                            return ColorUtils.RGBAToInt(new Color(255, 255, 100));
                        }
                        return this.color;
                    }

                    @Override
                    public void onClicked(int x, int y, int button) {
                        GuiComboBoxExtensionCategory.this.onSelectionChange(itemIndex);
                    }
                };
                this.controls.add(label);
                height += 15;
            }
        }
        this.refreshControls();
    }

    public void onSelectionChange(int index) {
        if (index != -1) {
            this.comboBox.select(index);
        }
        this.comboBox.closeBox();
    }

    @Override
    public boolean canOverlap() {
        return true;
    }
}

