/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import java.util.ArrayList;
import java.util.List;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.client.gui.GuiMachine;
import mustapelto.deepmoblearning.client.util.StringAnimator;
import mustapelto.deepmoblearning.common.tiles.TileEntitySimulationChamber;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.Point;
import mustapelto.deepmoblearning.common.util.Rect;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiSimulationChamber
extends GuiMachine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/simulation_chamber.png");
    private static final int WIDTH = 232;
    private static final int HEIGHT = 230;
    private static final Rect MAIN_GUI = new Rect(8, 0, 216, 141);
    private static final Point INFO_BOX = new Point(18, 9);
    private static final Point CONSOLE = new Point(29, 51);
    private static final int REDSTONE_DEACTIVATED_LINE_LENGTH = 28;
    private static final int BLINKING_CURSOR_SPEED = 16;
    private static final Rect DATA_BAR = new Rect(14, 47, 7, 87);
    private static final Rect ENERGY_BAR = new Rect(211, 47, 7, 87);
    private static final Point REDSTONE_BUTTON = new Point(-14, 24);
    private final StringAnimator progressAnimator = new StringAnimator();
    private final StringAnimator emptyDisplayAnimator = new StringAnimator();
    private final StringAnimator dataModelErrorAnimator = new StringAnimator();
    private final StringAnimator simulationErrorAnimator = new StringAnimator();
    private final TileEntitySimulationChamber simulationChamber;
    private ItemStack dataModel;
    private DataModelError dataModelError = DataModelError.NONE;
    private SimulationError simulationError = SimulationError.NONE;
    private boolean redstoneDeactivated = false;
    private int currentIteration;
    private boolean currentPristineSuccess;

    public GuiSimulationChamber(TileEntitySimulationChamber tileEntity, EntityPlayer player, World world) {
        super(tileEntity, player, world, 232, 230, REDSTONE_BUTTON);
        this.simulationChamber = tileEntity;
        this.dataModel = tileEntity.getDataModel();
        this.prepareStringAnimators();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.dataModel = this.simulationChamber.getDataModel();
        if (!this.simulationChamber.hasDataModel()) {
            if (this.dataModelError == DataModelError.MISSING) {
                return;
            }
            this.dataModelErrorAnimator.setString(AnimatedString.ERROR_DATA_MODEL_TEXT_1, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.no_data_model_1", (Object[])new Object[0]));
            this.dataModelErrorAnimator.setString(AnimatedString.ERROR_DATA_MODEL_TEXT_2, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.no_data_model_2", (Object[])new Object[0]));
            this.dataModelErrorAnimator.reset();
            this.dataModelError = DataModelError.MISSING;
            return;
        }
        if (!this.simulationChamber.canDataModelSimulate()) {
            if (this.dataModelError == DataModelError.FAULTY) {
                return;
            }
            this.dataModelErrorAnimator.setString(AnimatedString.ERROR_DATA_MODEL_TEXT_1, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.model_cannot_simulate_1", (Object[])new Object[0]));
            this.dataModelErrorAnimator.setString(AnimatedString.ERROR_DATA_MODEL_TEXT_2, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.model_cannot_simulate_2", (Object[])new Object[0]));
            this.dataModelErrorAnimator.reset();
            this.dataModelError = DataModelError.FAULTY;
            return;
        }
        this.dataModelError = DataModelError.NONE;
        this.emptyDisplayAnimator.reset();
        boolean bl = this.redstoneDeactivated = !this.tileEntity.isRedstoneActive();
        if (this.redstoneDeactivated) {
            return;
        }
        if (!this.simulationChamber.hasPolymerClay() && !this.tileEntity.isCrafting()) {
            if (this.simulationError == SimulationError.POLYMER) {
                return;
            }
            this.simulationErrorAnimator.setString(AnimatedString.ERROR_SIMULATION_TEXT, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.no_polymer", (Object[])new Object[0]));
            this.simulationErrorAnimator.reset();
            this.simulationError = SimulationError.POLYMER;
            return;
        }
        if (!this.tileEntity.hasEnergyForCrafting()) {
            if (this.simulationError == SimulationError.ENERGY) {
                return;
            }
            this.simulationErrorAnimator.setString(AnimatedString.ERROR_SIMULATION_TEXT, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.no_energy", (Object[])new Object[0]));
            this.simulationErrorAnimator.reset();
            this.simulationError = SimulationError.ENERGY;
            return;
        }
        if (this.simulationChamber.isPristineMatterOutputFull() || this.simulationChamber.isLivingMatterOutputFull()) {
            if (this.simulationError == SimulationError.OUTPUT) {
                return;
            }
            this.simulationErrorAnimator.setString(AnimatedString.ERROR_SIMULATION_TEXT, I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.output_full", (Object[])new Object[0]));
            this.simulationErrorAnimator.reset();
            this.simulationError = SimulationError.OUTPUT;
            return;
        }
        this.simulationError = SimulationError.NONE;
        int iteration = DataModelHelper.getTotalSimulationCount(this.dataModel) + 1;
        boolean pristineSuccess = this.simulationChamber.isPristineSuccess();
        if (iteration == this.currentIteration && pristineSuccess == this.currentPristineSuccess) {
            return;
        }
        this.currentIteration = iteration;
        this.currentPristineSuccess = pristineSuccess;
        String iterationString = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.iteration", (Object[])new Object[]{iteration});
        this.progressAnimator.setString(AnimatedString.SIMULATION_ITERATION, iterationString);
        String pristineString = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.pristine", (Object[])new Object[0]);
        String successString = TextFormatting.GREEN + I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.pristine_success", (Object[])new Object[0]) + TextFormatting.RESET;
        String failureString = TextFormatting.RED + I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.pristine_failure", (Object[])new Object[0]) + TextFormatting.RESET;
        pristineString = pristineString + " " + (pristineSuccess ? successString : failureString);
        this.progressAnimator.setString(AnimatedString.SIMULATION_PRISTINE, pristineString);
        this.progressAnimator.reset();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        ArrayList<String> tooltip = new ArrayList<String>();
        if (DATA_BAR.isInside(x, y)) {
            if (this.simulationChamber.hasDataModel()) {
                if (!DataModelHelper.isMaxTier(this.dataModel)) {
                    String currentData = String.valueOf(DataModelHelper.getCurrentTierDataCount(this.dataModel));
                    String maxData = String.valueOf(DataModelHelper.getTierRequiredData(this.dataModel));
                    tooltip.add(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.tooltip.model_data", (Object[])new Object[]{currentData + "/" + maxData}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.tooltip.model_max", (Object[])new Object[0]));
                }
                if (!DataModelHelper.canSimulate(this.dataModel)) {
                    tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.tooltip.model_cannot_simulate", (Object[])new Object[0]) + TextFormatting.RESET);
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.tooltip.model_missing", (Object[])new Object[0]));
            }
            this.func_146283_a(tooltip, x, y);
        } else if (ENERGY_BAR.isInside(x, y)) {
            String currentEnergy = String.valueOf(this.tileEntity.getEnergy());
            String maxEnergy = String.valueOf(this.tileEntity.getMaxEnergy());
            tooltip.add(currentEnergy + "/" + maxEnergy + " RF");
            if (this.simulationChamber.hasDataModel()) {
                int energyDrain = this.tileEntity.getCraftingEnergyCost();
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.tooltip.sim_cost", (Object[])new Object[]{energyDrain}));
            }
            this.func_146283_a(tooltip, x, y);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.textureManager.func_110577_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i + GuiSimulationChamber.MAIN_GUI.LEFT, this.field_147009_r + GuiSimulationChamber.MAIN_GUI.TOP, TextureCoords.MAIN_GUI.X, TextureCoords.MAIN_GUI.Y, GuiSimulationChamber.MAIN_GUI.WIDTH, GuiSimulationChamber.MAIN_GUI.HEIGHT);
        this.func_73729_b(this.field_147003_i + DMLConstants.Gui.SimulationChamber.DATA_MODEL_SLOT.LEFT, this.field_147009_r + DMLConstants.Gui.SimulationChamber.DATA_MODEL_SLOT.TOP, TextureCoords.DATA_MODEL_SLOT.X, TextureCoords.DATA_MODEL_SLOT.Y, DMLConstants.Gui.SimulationChamber.DATA_MODEL_SLOT.WIDTH, DMLConstants.Gui.SimulationChamber.DATA_MODEL_SLOT.HEIGHT);
        if (this.dataModelError == DataModelError.NONE) {
            int dataBarHeight;
            if (DataModelHelper.isMaxTier(this.dataModel)) {
                dataBarHeight = GuiSimulationChamber.DATA_BAR.HEIGHT;
            } else {
                int currentData = DataModelHelper.getCurrentTierDataCount(this.dataModel);
                int tierMaxData = DataModelHelper.getTierRequiredData(this.dataModel);
                dataBarHeight = (int)((float)currentData / (float)tierMaxData * (float)GuiSimulationChamber.DATA_BAR.HEIGHT);
            }
            int dataBarOffset = GuiSimulationChamber.DATA_BAR.HEIGHT - dataBarHeight;
            this.func_73729_b(this.field_147003_i + GuiSimulationChamber.DATA_BAR.LEFT, this.field_147009_r + GuiSimulationChamber.DATA_BAR.TOP + dataBarOffset, TextureCoords.DATA_BAR.X, TextureCoords.DATA_BAR.Y, GuiSimulationChamber.DATA_BAR.WIDTH, dataBarHeight);
        }
        this.drawEnergyBar(ENERGY_BAR, TextureCoords.ENERGY_BAR);
        this.drawPlayerInventory(this.field_147003_i + DMLConstants.Gui.SimulationChamber.PLAYER_INVENTORY.X, this.field_147009_r + DMLConstants.Gui.SimulationChamber.PLAYER_INVENTORY.Y);
        this.drawInfoboxText(this.deltaTime, this.field_147003_i + GuiSimulationChamber.INFO_BOX.X, this.field_147009_r + GuiSimulationChamber.INFO_BOX.Y);
        this.drawConsoleText(this.deltaTime, this.field_147003_i + GuiSimulationChamber.CONSOLE.X, this.field_147009_r + GuiSimulationChamber.CONSOLE.Y);
    }

    private void drawInfoboxText(float advanceAmount, int left, int top) {
        ArrayList<String> strings = new ArrayList();
        if (this.dataModelError == DataModelError.NONE) {
            String tier = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.data_model_info.tier", (Object[])new Object[0]);
            String iterations = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.data_model_info.iterations", (Object[])new Object[0]);
            String pristine = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.data_model_info.pristine", (Object[])new Object[0]);
            strings.add(tier + ": " + DataModelHelper.getTierDisplayNameFormatted(this.dataModel));
            strings.add(iterations + ": " + DataModelHelper.getTotalSimulationCount(this.dataModel));
            strings.add(pristine + ": " + DataModelHelper.getPristineChance(this.dataModel));
        } else {
            this.dataModelErrorAnimator.advance(advanceAmount);
            strings = this.dataModelErrorAnimator.getCurrentStrings();
        }
        this.drawStrings(strings, left, top);
    }

    private void drawConsoleText(float advanceAmount, int left, int top) {
        List<Object> strings;
        if (this.dataModelError != DataModelError.NONE) {
            this.emptyDisplayAnimator.advance(advanceAmount);
            strings = this.emptyDisplayAnimator.getCurrentStrings();
        } else if (this.redstoneDeactivated) {
            strings = new ArrayList();
            strings.add(TextFormatting.RED + StringHelper.getDashedLine(28) + TextFormatting.RESET);
            strings.add(TextFormatting.RED + StringHelper.pad(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.redstone_deactivated_1", (Object[])new Object[0]), 28) + TextFormatting.RESET);
            strings.add(TextFormatting.RED + StringHelper.pad(I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.redstone_deactivated_2", (Object[])new Object[0]), 28) + TextFormatting.RESET);
            strings.add(TextFormatting.RED + StringHelper.getDashedLine(28) + TextFormatting.RESET);
        } else if (this.simulationError != SimulationError.NONE) {
            this.simulationErrorAnimator.advance(advanceAmount);
            strings = this.simulationErrorAnimator.getCurrentStrings();
        } else {
            float relativeProgress = this.tileEntity.getRelativeCraftingProgress();
            this.progressAnimator.goToRelativePosition(relativeProgress);
            strings = this.progressAnimator.getCurrentStrings();
        }
        this.drawStrings(strings, left, top);
    }

    private void drawStrings(List<String> strings, int left, int top) {
        for (int i = 0; i < strings.size(); ++i) {
            this.func_73731_b(this.field_146289_q, strings.get(i), left, top + i * 12, 0xFFFFFF);
        }
    }

    private void prepareStringAnimators() {
        String blinkingCursor = " _";
        String simulationLaunching = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.launching", (Object[])new Object[0]);
        String simulationLoading = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.loading", (Object[])new Object[0]);
        String simulationAssessing = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.assessing", (Object[])new Object[0]);
        String simulationEngaged = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.engaged", (Object[])new Object[0]);
        String simulationProcessing = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.simulation_text.processing", (Object[])new Object[0]) + " . . . . .";
        String error = I18n.func_135052_a((String)"deepmoblearning.simulation_chamber.error_text.error", (Object[])new Object[0]);
        this.progressAnimator.addString(AnimatedString.SIMULATION_LAUNCHING, simulationLaunching);
        this.progressAnimator.addString(AnimatedString.SIMULATION_ITERATION, "");
        this.progressAnimator.addString(AnimatedString.SIMULATION_LOADING, simulationLoading);
        this.progressAnimator.addString(AnimatedString.SIMULATION_ASSESSING, simulationAssessing);
        this.progressAnimator.addString(AnimatedString.SIMULATION_ENGAGED, simulationEngaged);
        this.progressAnimator.addString(AnimatedString.SIMULATION_PRISTINE, "");
        this.progressAnimator.addString(AnimatedString.SIMULATION_PROCESSING, simulationProcessing);
        this.emptyDisplayAnimator.addString(AnimatedString.UNDERLINE, blinkingCursor, 16.0f, true);
        this.dataModelErrorAnimator.addString(AnimatedString.ERROR_DATA_MODEL_HEADING, error);
        this.dataModelErrorAnimator.addString(AnimatedString.ERROR_DATA_MODEL_TEXT_1, "");
        this.dataModelErrorAnimator.addString(AnimatedString.ERROR_DATA_MODEL_TEXT_2, "");
        this.simulationErrorAnimator.addString(AnimatedString.ERROR_SIMULATION_HEADING, error);
        this.simulationErrorAnimator.addString(AnimatedString.ERROR_SIMULATION_TEXT, "");
        this.simulationErrorAnimator.addString(AnimatedString.UNDERLINE, blinkingCursor, 16.0f, true);
    }

    private static enum SimulationError {
        NONE,
        ENERGY,
        POLYMER,
        OUTPUT;

    }

    private static enum DataModelError {
        NONE,
        MISSING,
        FAULTY;

    }

    public static enum AnimatedString {
        UNDERLINE,
        SIMULATION_LAUNCHING,
        SIMULATION_ITERATION,
        SIMULATION_LOADING,
        SIMULATION_ASSESSING,
        SIMULATION_ENGAGED,
        SIMULATION_PRISTINE,
        SIMULATION_PROCESSING,
        ERROR_DATA_MODEL_HEADING,
        ERROR_DATA_MODEL_TEXT_1,
        ERROR_DATA_MODEL_TEXT_2,
        ERROR_SIMULATION_HEADING,
        ERROR_SIMULATION_TEXT;

    }

    private static final class TextureCoords {
        private static final Point MAIN_GUI = new Point(0, 0);
        private static final Point DATA_BAR = new Point(18, 141);
        private static final Point ENERGY_BAR = new Point(25, 141);
        private static final Point DATA_MODEL_SLOT = new Point(0, 141);

        private TextureCoords() {
        }
    }
}

