/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.blocks.BlockBase;
import mustapelto.deepmoblearning.common.blocks.BlockInfusedIngot;
import mustapelto.deepmoblearning.common.blocks.BlockLootFabricator;
import mustapelto.deepmoblearning.common.blocks.BlockMachineCasing;
import mustapelto.deepmoblearning.common.blocks.BlockSimulationChamber;
import mustapelto.deepmoblearning.common.blocks.BlockTrialKeystone;
import mustapelto.deepmoblearning.common.entities.EntityGlitch;
import mustapelto.deepmoblearning.common.entities.EntityGlitchOrb;
import mustapelto.deepmoblearning.common.entities.EntityItemGlitchFragment;
import mustapelto.deepmoblearning.common.entities.EntityTrialCaveSpider;
import mustapelto.deepmoblearning.common.entities.EntityTrialEnderman;
import mustapelto.deepmoblearning.common.entities.EntityTrialSlime;
import mustapelto.deepmoblearning.common.entities.EntityTrialSpider;
import mustapelto.deepmoblearning.common.items.ItemCreativeModelLearner;
import mustapelto.deepmoblearning.common.items.ItemDataModel;
import mustapelto.deepmoblearning.common.items.ItemDataModelBlank;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.items.ItemGlitchArmor;
import mustapelto.deepmoblearning.common.items.ItemGlitchFragment;
import mustapelto.deepmoblearning.common.items.ItemGlitchHeart;
import mustapelto.deepmoblearning.common.items.ItemGlitchIngot;
import mustapelto.deepmoblearning.common.items.ItemGlitchSword;
import mustapelto.deepmoblearning.common.items.ItemLivingMatter;
import mustapelto.deepmoblearning.common.items.ItemPolymerClay;
import mustapelto.deepmoblearning.common.items.ItemPristineMatter;
import mustapelto.deepmoblearning.common.items.ItemSootedPlate;
import mustapelto.deepmoblearning.common.items.ItemSootedRedstone;
import mustapelto.deepmoblearning.common.items.ItemTrialKey;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataLivingMatter;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import mustapelto.deepmoblearning.common.tiles.TileEntityLootFabricator;
import mustapelto.deepmoblearning.common.tiles.TileEntitySimulationChamber;
import mustapelto.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class DMLRegistry {
    public static final NonNullList<Item> registeredItems = NonNullList.func_191196_a();
    public static final NonNullList<BlockBase> registeredBlocks = NonNullList.func_191196_a();
    private static ImmutableMap<String, ItemLivingMatter> registeredLivingMatter;
    private static ImmutableMap<String, ItemDataModel> registeredDataModels;
    private static ImmutableMap<String, ItemPristineMatter> registeredPristineMatter;
    public static final BlockInfusedIngot BLOCK_INFUSED_INGOT;
    public static final BlockMachineCasing BLOCK_MACHINE_CASING;
    public static final BlockSimulationChamber BLOCK_SIMULATION_CHAMBER;
    public static final BlockLootFabricator BLOCK_LOOT_FABRICATOR;
    public static final BlockTrialKeystone BLOCK_TRIAL_KEYSTONE;
    public static final ItemDeepLearner ITEM_DEEP_LEARNER;
    public static final ItemPolymerClay ITEM_POLYMER_CLAY;
    public static final ItemDataModelBlank ITEM_DATA_MODEL_BLANK;
    public static final ItemCreativeModelLearner ITEM_CREATIVE_MODEL_LEARNER;
    public static final ItemSootedRedstone ITEM_SOOTED_REDSTONE;
    public static final ItemSootedPlate ITEM_SOOTED_PLATE;
    public static final ItemGlitchIngot ITEM_GLITCH_INGOT;
    public static final ItemGlitchFragment ITEM_GLITCH_FRAGMENT;
    public static final ItemGlitchHeart ITEM_GLITCH_HEART;
    public static final ItemTrialKey ITEM_TRIAL_KEY;
    public static final ItemGlitchArmor.ItemGlitchHelmet ITEM_GLITCH_HELMET;
    public static final ItemGlitchArmor.ItemGlitchChestplate ITEM_GLITCH_CHESTPLATE;
    public static final ItemGlitchArmor.ItemGlitchLeggings ITEM_GLITCH_LEGGINGS;
    public static final ItemGlitchArmor.ItemGlitchBoots ITEM_GLITCH_BOOTS;
    public static final ItemGlitchSword ITEM_GLITCH_SWORD;
    private static int entityId;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        DMLRelearned.logger.info("Registering Blocks...");
        registeredBlocks.add((Object)BLOCK_INFUSED_INGOT);
        registeredBlocks.add((Object)BLOCK_MACHINE_CASING);
        registeredBlocks.add((Object)BLOCK_SIMULATION_CHAMBER);
        registeredBlocks.add((Object)BLOCK_LOOT_FABRICATOR);
        registeredBlocks.add((Object)BLOCK_TRIAL_KEYSTONE);
        IForgeRegistry registry = event.getRegistry();
        registeredBlocks.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GameRegistry.registerTileEntity(TileEntitySimulationChamber.class, (ResourceLocation)new ResourceLocation("deepmoblearning", "simulation_chamber"));
        GameRegistry.registerTileEntity(TileEntityLootFabricator.class, (ResourceLocation)new ResourceLocation("deepmoblearning", "extraction_chamber"));
        GameRegistry.registerTileEntity(TileEntityTrialKeystone.class, (ResourceLocation)new ResourceLocation("deepmoblearning", "trial_keystone"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        DMLRelearned.logger.info("Registering Items...");
        registeredItems.add((Object)ITEM_POLYMER_CLAY);
        registeredItems.add((Object)ITEM_DATA_MODEL_BLANK);
        registeredItems.add((Object)ITEM_DEEP_LEARNER);
        registeredItems.add((Object)ITEM_CREATIVE_MODEL_LEARNER);
        registeredItems.add((Object)ITEM_SOOTED_REDSTONE);
        registeredItems.add((Object)ITEM_SOOTED_PLATE);
        registeredItems.add((Object)ITEM_GLITCH_INGOT);
        registeredItems.add((Object)ITEM_GLITCH_FRAGMENT);
        registeredItems.add((Object)ITEM_GLITCH_HEART);
        registeredItems.add((Object)ITEM_TRIAL_KEY);
        registeredItems.add((Object)ITEM_GLITCH_HELMET);
        registeredItems.add((Object)ITEM_GLITCH_CHESTPLATE);
        registeredItems.add((Object)ITEM_GLITCH_LEGGINGS);
        registeredItems.add((Object)ITEM_GLITCH_BOOTS);
        registeredItems.add((Object)ITEM_GLITCH_SWORD);
        DMLRelearned.logger.info("Registering Living Matter...");
        ImmutableMap.Builder livingMatterBuilder = ImmutableMap.builder();
        MetadataManager.getLivingMatterMetadataList().forEach(metadata -> livingMatterBuilder.put((Object)metadata.getID(), (Object)new ItemLivingMatter((MetadataLivingMatter)metadata)));
        registeredLivingMatter = livingMatterBuilder.build();
        registeredItems.addAll((Collection)registeredLivingMatter.values());
        DMLRelearned.logger.info("Registering Data Models and Pristine Matter...");
        ImmutableMap.Builder dataModelBuilder = ImmutableMap.builder();
        ImmutableMap.Builder pristineMatterBuilder = ImmutableMap.builder();
        MetadataManager.getDataModelMetadataList().forEach(metadata -> {
            dataModelBuilder.put((Object)metadata.getID(), (Object)new ItemDataModel((MetadataDataModel)metadata));
            pristineMatterBuilder.put((Object)metadata.getID(), (Object)new ItemPristineMatter((MetadataDataModel)metadata));
        });
        registeredDataModels = dataModelBuilder.build();
        registeredPristineMatter = pristineMatterBuilder.build();
        registeredItems.addAll((Collection)registeredDataModels.values());
        registeredItems.addAll((Collection)registeredPristineMatter.values());
        IForgeRegistry registry = event.getRegistry();
        registeredItems.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        registeredBlocks.forEach(block -> block.getItemBlock().ifPresent(arg_0 -> ((IForgeRegistry)registry).register(arg_0)));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        ResourceLocation entityGlitchName = new ResourceLocation("deepmoblearning", "glitch");
        ResourceLocation entityGlitchOrbName = new ResourceLocation("deepmoblearning", "glitch_orb");
        ResourceLocation entityTrialEndermanName = new ResourceLocation("deepmoblearning", "trial_enderman");
        ResourceLocation entityTrialSpiderName = new ResourceLocation("deepmoblearning", "trial_spider");
        ResourceLocation entityTrialCaveSpiderName = new ResourceLocation("deepmoblearning", "trial_cave_spider");
        ResourceLocation entityTrialSlimeName = new ResourceLocation("deepmoblearning", "trial_slime");
        ResourceLocation itemGlitchFragmentName = new ResourceLocation("deepmoblearning", "item_glitch_fragment");
        EntityEntry entityGlitch = EntityEntryBuilder.create().entity(EntityGlitch.class).id(entityGlitchName, entityId++).name("deepmoblearning." + entityGlitchName.func_110623_a()).tracker(64, 1, true).egg(0, 6478079).build();
        EntityEntry entityGlitchOrb = EntityEntryBuilder.create().entity(EntityGlitchOrb.class).id(entityGlitchOrbName, entityId++).name("deepmoblearning." + entityGlitchOrbName.func_110623_a()).tracker(64, 1, true).build();
        EntityEntry entityTrialEnderman = EntityEntryBuilder.create().entity(EntityTrialEnderman.class).id(entityTrialEndermanName, entityId++).name("deepmoblearning." + entityTrialEndermanName.func_110623_a()).tracker(64, 1, true).build();
        EntityEntry entityTrialSpider = EntityEntryBuilder.create().entity(EntityTrialSpider.class).id(entityTrialSpiderName, entityId++).name("deepmoblearning." + entityTrialSpiderName.func_110623_a()).tracker(64, 1, true).build();
        EntityEntry entityTrialCaveSpider = EntityEntryBuilder.create().entity(EntityTrialCaveSpider.class).id(entityTrialCaveSpiderName, entityId++).name("deepmoblearning." + entityTrialCaveSpiderName.func_110623_a()).tracker(64, 1, true).build();
        EntityEntry entityTrialSlime = EntityEntryBuilder.create().entity(EntityTrialSlime.class).id(entityTrialSlimeName, entityId++).name("deepmoblearning." + entityTrialSlimeName.func_110623_a()).tracker(64, 1, true).build();
        EntityEntry itemGlitchFragment = EntityEntryBuilder.create().entity(EntityItemGlitchFragment.class).id(itemGlitchFragmentName, entityId++).name(itemGlitchFragmentName.func_110623_a()).tracker(64, 1, true).build();
        registry.registerAll((IForgeRegistryEntry[])new EntityEntry[]{entityGlitch, entityGlitchOrb, entityTrialEnderman, entityTrialSpider, entityTrialCaveSpider, entityTrialSlime, itemGlitchFragment});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        DMLRelearned.logger.info("Registering Dynamic Recipes...");
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])MetadataManager.getCraftingRecipes().toArray((Object[])new IRecipe[0]));
    }

    public static ItemStack getLivingMatter(String id) {
        if (registeredLivingMatter.containsKey((Object)id)) {
            return new ItemStack((Item)registeredLivingMatter.get((Object)id));
        }
        if (registeredLivingMatter.size() > 0) {
            return new ItemStack((Item)registeredLivingMatter.values().asList().get(0));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPristineMatter(String id) {
        if (registeredPristineMatter.containsKey((Object)id)) {
            return new ItemStack((Item)registeredPristineMatter.get((Object)id));
        }
        return ItemStack.field_190927_a;
    }

    public static Collection<ItemPristineMatter> getPristineMatters() {
        return registeredPristineMatter.values();
    }

    public static ItemStack getDataModel(String id) {
        if (registeredDataModels.containsKey((Object)id)) {
            return new ItemStack((Item)registeredDataModels.get((Object)id));
        }
        return ItemStack.field_190927_a;
    }

    public static Collection<ItemDataModel> getDataModels() {
        return registeredDataModels.values();
    }

    static {
        BLOCK_INFUSED_INGOT = new BlockInfusedIngot();
        BLOCK_MACHINE_CASING = new BlockMachineCasing();
        BLOCK_SIMULATION_CHAMBER = new BlockSimulationChamber();
        BLOCK_LOOT_FABRICATOR = new BlockLootFabricator();
        BLOCK_TRIAL_KEYSTONE = new BlockTrialKeystone();
        ITEM_DEEP_LEARNER = new ItemDeepLearner();
        ITEM_POLYMER_CLAY = new ItemPolymerClay();
        ITEM_DATA_MODEL_BLANK = new ItemDataModelBlank();
        ITEM_CREATIVE_MODEL_LEARNER = new ItemCreativeModelLearner();
        ITEM_SOOTED_REDSTONE = new ItemSootedRedstone();
        ITEM_SOOTED_PLATE = new ItemSootedPlate();
        ITEM_GLITCH_INGOT = new ItemGlitchIngot();
        ITEM_GLITCH_FRAGMENT = new ItemGlitchFragment();
        ITEM_GLITCH_HEART = new ItemGlitchHeart();
        ITEM_TRIAL_KEY = new ItemTrialKey();
        ITEM_GLITCH_HELMET = new ItemGlitchArmor.ItemGlitchHelmet();
        ITEM_GLITCH_CHESTPLATE = new ItemGlitchArmor.ItemGlitchChestplate();
        ITEM_GLITCH_LEGGINGS = new ItemGlitchArmor.ItemGlitchLeggings();
        ITEM_GLITCH_BOOTS = new ItemGlitchArmor.ItemGlitchBoots();
        ITEM_GLITCH_SWORD = new ItemGlitchSword();
        entityId = 0;
    }
}

