/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.energy;

import io.netty.buffer.ByteBuf;
import mustapelto.deepmoblearning.common.util.MathHelper;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;

public class DMLEnergyStorage
extends EnergyStorage {
    public DMLEnergyStorage(int capacity, int maxReceive) {
        super(capacity, maxReceive, 0);
    }

    public boolean canExtract() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.onEnergyChanged();
        return super.receiveEnergy(maxReceive, simulate);
    }

    public void voidEnergy(int energy) {
        this.energy -= Math.min(this.energy, energy);
        this.onEnergyChanged();
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energy);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.setEnergy(NBTHelper.getInteger(compound, "energy", 0));
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeInt(this.energy);
    }

    public void readFromBuffer(ByteBuf buf) {
        this.setEnergy(buf.readInt());
    }

    private void setEnergy(int energy) {
        this.energy = MathHelper.clamp(energy, 0, this.getMaxEnergyStored());
        this.onEnergyChanged();
    }

    protected void onEnergyChanged() {
    }
}

