/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.tiles.CraftingState;
import mustapelto.deepmoblearning.common.tiles.TileEntityMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCraftingState
implements IMessage {
    private BlockPos pos;
    private CraftingState craftingState;

    public MessageCraftingState() {
        this.craftingState = CraftingState.IDLE;
    }

    public MessageCraftingState(BlockPos pos, CraftingState craftingState) {
        this.pos = pos;
        this.craftingState = craftingState;
    }

    public MessageCraftingState(TileEntityMachine te) {
        this(te.func_174877_v(), te.getCraftingState());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.craftingState.getIndex());
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.craftingState = CraftingState.byIndex(buf.readInt());
    }

    public static class Handler
    implements IMessageHandler<MessageCraftingState, IMessage> {
        @Nullable
        public IMessage onMessage(MessageCraftingState message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                TileEntityMachine te = (TileEntityMachine)mc.field_71441_e.func_175625_s(message.pos);
                if (te != null) {
                    te.setCraftingState(message.craftingState);
                }
            });
            return null;
        }
    }
}

