/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.datapack;

import com.ezrol.terry.lib.huffstruct.StructNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RuntimeSettings
extends StructNode {
    private UuidTypeNode saveUUID;
    private HashMap<String, String> savedFiles;

    public RuntimeSettings(StructNode base) {
        List<StructNode> fileList;
        List<StructNode> data = base == null ? null : base.getArray();
        this.savedFiles = new HashMap();
        if (data == null || data.size() == 0) {
            this.saveUUID = (UuidTypeNode)DefaultWorldGenerator.modConfig.getSettings().getWorldList().get(0).getField(WorldTypeNode.Fields.UUID);
            this.saveUUID = new UuidTypeNode(this.saveUUID);
            return;
        }
        if (data.size() >= 1) {
            this.saveUUID = new UuidTypeNode(data.get(0));
        }
        if (data.size() >= 2 && (fileList = data.get(1).getArray()) != null) {
            for (StructNode n : fileList) {
                StringListTypeNode elements = new StringListTypeNode(n, new String[0]);
                if (elements.getValue().size() != 2) continue;
                this.savedFiles.put(elements.getValue().get(0), elements.getValue().get(1));
            }
        }
    }

    public UUID getSaveUUID() {
        return this.saveUUID.getValue();
    }

    public void setSaveUUID(UUID id) {
        this.saveUUID.setValue(id);
    }

    public String getCachedChecksum(String fileName) {
        return this.savedFiles.getOrDefault(fileName, "");
    }

    public void updateChecksum(String fileName, String checksum) {
        if (checksum.equals("")) {
            if (this.savedFiles.containsKey(fileName)) {
                this.savedFiles.remove(fileName);
            }
        } else {
            this.savedFiles.put(fileName, checksum);
        }
    }

    public <T> List<String> findMissing(Map<String, T> source) {
        ArrayList<String> rval = new ArrayList<String>();
        for (String key : this.savedFiles.keySet()) {
            if (source.containsKey(key)) continue;
            rval.add(key);
        }
        return rval;
    }

    @Override
    public List<StructNode> getArray() {
        LinkedList<StructNode> data = new LinkedList<StructNode>();
        LinkedList<StructNode> fileList = new LinkedList<StructNode>();
        data.add(this.saveUUID);
        for (String fileName : this.savedFiles.keySet()) {
            fileList.add(new StringListTypeNode(null, new String[]{fileName, this.savedFiles.get(fileName)}));
        }
        data.add(StructNode.newArray(fileList));
        return data;
    }

    @Override
    public byte[] getBinaryString() {
        return null;
    }
}

