/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.gui;

import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.GuiCreateCustomWorld;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class DefaultWorldSelectionList
extends GuiScreen {
    private GuiScreen parent;
    private StringSlotList list = null;
    private String title;
    private static final int BTN_OK = 400;
    private List<WorldTypeNode> choices;
    private static HashMap<String, ResourceLocation> userIcons = null;

    public DefaultWorldSelectionList(GuiScreen par, List<WorldTypeNode> validNodes) {
        this.parent = par;
        this.choices = validNodes;
        this.title = I18n.func_135052_a((String)"defaultworldgenerator-port.chooseworld.gui.title", (Object[])new Object[0]);
    }

    public void func_73866_w_() {
        int idx = this.list == null ? 0 : this.list.selected;
        this.list = new StringSlotList(this.field_146294_l, this.field_146295_m);
        this.list.selected = idx;
        this.field_146292_n.add(new GuiButton(400, this.field_146294_l / 4 + 20, this.field_146295_m - 28, this.field_146294_l / 2 - 40, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.chooseworld.gui.select", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 400: {
                if (this.list.selected < 0 || this.list.selected >= this.choices.size()) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiCreateCustomWorld(this.parent, this.choices.get(this.list.selected)));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.func_178039_p();
    }

    private class StringSlotList
    extends GuiSlot {
        int selected;

        private StringSlotList(int screen_width, int screen_height) {
            super(DefaultWorldSelectionList.this.field_146297_k, screen_width, screen_height - 52, 26, 36, 48);
            this.selected = -1;
            this.field_148152_e = 0;
            this.field_148151_d = screen_width;
            this.field_148155_a = this.field_148151_d - this.field_148152_e;
            this.field_148153_b = 26;
            this.field_148158_l = this.field_148154_c = screen_height - 36;
        }

        protected int func_148127_b() {
            return DefaultWorldSelectionList.this.choices.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.selected = slotIndex;
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.selected;
        }

        protected void func_148123_a() {
            DefaultWorldSelectionList.this.func_146276_q_();
        }

        private void internalIcon(int xPos, int yPos, int index) {
            DefaultWorldSelectionList.this.func_73730_a((xPos += 5) - 1, xPos + 32, yPos - 1, -2039584);
            DefaultWorldSelectionList.this.func_73730_a(xPos - 1, xPos + 32, yPos + 32, -6250336);
            DefaultWorldSelectionList.this.func_73728_b(xPos - 1, yPos - 1, yPos + 32, -2039584);
            DefaultWorldSelectionList.this.func_73728_b(xPos + 32, yPos - 1, yPos + 32, -6250336);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String[] filename = new String[]{"grass_side.png", "cobblestone.png", "iron_ore.png", "diamond_ore.png"};
            this.field_148161_k.func_110434_K().func_110577_a(new ResourceLocation("minecraft", "textures/blocks/" + filename[index % 4]));
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b((double)(xPos + 0), (double)(yPos + 32), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 32), (double)(yPos + 32), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 32), (double)(yPos + 0), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 0), (double)(yPos + 0), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }

        private void userIcon(int xPos, int yPos, String image) {
            ResourceLocation drawable;
            DefaultWorldSelectionList.this.func_73730_a((xPos += 5) - 1, xPos + 32, yPos - 1, -2039584);
            DefaultWorldSelectionList.this.func_73730_a(xPos - 1, xPos + 32, yPos + 32, -6250336);
            DefaultWorldSelectionList.this.func_73728_b(xPos - 1, yPos - 1, yPos + 32, -2039584);
            DefaultWorldSelectionList.this.func_73728_b(xPos + 32, yPos - 1, yPos + 32, -6250336);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (userIcons == null) {
                userIcons = new HashMap();
            }
            if (userIcons.containsKey(image)) {
                drawable = (ResourceLocation)userIcons.get(image);
            } else {
                try {
                    BufferedImage img = ImageIO.read(new File(DefaultWorldGenerator.modSettingsDir, image));
                    drawable = this.field_148161_k.func_110434_K().func_110578_a(image, new DynamicTexture(img));
                    userIcons.put(image, drawable);
                }
                catch (Exception e) {
                    Log.error("Unable to read in icon file: " + e);
                    return;
                }
            }
            this.field_148161_k.func_110434_K().func_110577_a(drawable);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b((double)(xPos + 0), (double)(yPos + 32), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 32), (double)(yPos + 32), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 32), (double)(yPos + 0), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(xPos + 0), (double)(yPos + 0), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }

        protected void func_192637_a(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
            String name = ((StringTypeNode)((WorldTypeNode)DefaultWorldSelectionList.this.choices.get(entryID)).getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).getValue();
            String desc = ((StringTypeNode)((WorldTypeNode)DefaultWorldSelectionList.this.choices.get(entryID)).getField(WorldTypeNode.Fields.CONFIGURATION_DESC)).getValue();
            String icon = ((StringTypeNode)((WorldTypeNode)DefaultWorldSelectionList.this.choices.get(entryID)).getField(WorldTypeNode.Fields.CONFIGURATION_IMAGE)).getValue();
            DefaultWorldSelectionList.this.field_146289_q.func_78276_b(name, insideLeft + 50, yPos + 4, 0xEEEEEE);
            DefaultWorldSelectionList.this.field_146289_q.func_78279_b(desc, insideLeft + 50, yPos + 14, this.func_148139_c() - 58, 0xAAAAAA);
            if (icon == null || icon.equals("")) {
                this.internalIcon(insideLeft + 4, yPos + 6, entryID);
            } else {
                this.userIcon(insideLeft + 4, yPos + 6, icon);
            }
        }

        public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
            super.func_148128_a(mouseXIn, mouseYIn, partialTicks);
            this.func_148136_c(this.field_148154_c - 1, DefaultWorldSelectionList.this.field_146295_m, 255, 255);
        }

        public int func_148139_c() {
            return this.field_148155_a / 6 * 4;
        }

        protected int func_148137_d() {
            return this.field_148155_a / 6 * 5 + 4;
        }
    }
}

