/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.densemetals.init;

import com.mcmoddev.densemetals.DenseMetalsConfig;
import com.mcmoddev.densemetals.blocks.BlockDenseOre;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="densemetals")
public class ModBlocks {
    public static final List<BlockDenseOre> DENSE_ORES = new ArrayList<BlockDenseOre>();

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ModBlocks.createDenseOre(Blocks.field_150366_p).stats(0, 96, 20), ModBlocks.createDenseOre(Blocks.field_150365_q).stats(0, 96, 25), ModBlocks.createDenseOre(Blocks.field_150352_o).stats(0, 35, 20), ModBlocks.createDenseOre(Blocks.field_150482_ag).stats(0, 30, 20), ModBlocks.createDenseOre(Blocks.field_150412_bA).stats(0, 96, 20), ModBlocks.createDenseOre(Blocks.field_150369_x).stats(0, 35, 20), ModBlocks.createDenseOre(Blocks.field_150450_ax).stats(0, 35, 20), ModBlocks.createDenseOre(Blocks.field_150449_bY).stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_iron_ore", "oreNetherIron").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_coal_ore", "oreNetherCoal").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_gold_ore", "oreNetherGold").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_diamond_ore", "oreNetherDiamond").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_emerald_ore", "oreNetherEmerald").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_lapis_ore", "oreNetherLapis").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_redstone_ore", "oreNetherRedstone").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("aluminum_ore", "oreAluminum").stats(0, 0, 0), ModBlocks.createDenseOre("copper_ore", "oreCopper").stats(20, 96, 20), ModBlocks.createDenseOre("iridium_ore", "oreIridium").stats(0, 0, 0), ModBlocks.createDenseOre("lead_ore", "oreLead").stats(0, 35, 20), ModBlocks.createDenseOre("mithril_ore", "oreMithril").stats(0, 0, 0), ModBlocks.createDenseOre("nickel_ore", "oreNickel").stats(0, 20, 20), ModBlocks.createDenseOre("platinum_ore", "orePlatinum").stats(0, 0, 0), ModBlocks.createDenseOre("silver_ore", "oreSilver").stats(0, 35, 20), ModBlocks.createDenseOre("tin_ore", "oreTin").stats(20, 55, 20), ModBlocks.createDenseOre("nether_aluminum_ore", "oreNetherAluminum").stats(0, 128, 0).dim(-1), ModBlocks.createDenseOre("nether_copper_ore", "oreNetherCopper").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_iridium_ore", "oreNetherIridium").stats(0, 128, 0).dim(-1), ModBlocks.createDenseOre("nether_lead_ore", "oreNetherLead").stats(0, 128, 10).dim(-1), ModBlocks.createDenseOre("nether_mithril_ore", "oreNetherMithril").stats(0, 128, 0).dim(-1), ModBlocks.createDenseOre("nether_nickel_ore", "oreNetherNickel").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_platinum_ore", "oreNetherPlatinum").stats(0, 128, 0).dim(-1), ModBlocks.createDenseOre("nether_silver_ore", "oreNetherSilver").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("nether_tin_ore", "oreNetherTin").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("adamantine_ore", "oreAdamantine").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("coldiron_ore", "oreColdiron").stats(0, 128, 20).dim(-1), ModBlocks.createDenseOre("starsteel_ore", "oreStarsteel").stats(0, 80, 20).dim(1), ModBlocks.createDenseOre("zinc_ore", "oreZinc").stats(0, 96, 20), ModBlocks.createDenseOre("mercury_ore", "oreMercury").stats(0, 32, 20), ModBlocks.createDenseOre("antimony_ore", "oreAntimony").stats(0, 0, 0), ModBlocks.createDenseOre("bismuth_ore", "oreBismuth").stats(0, 0, 0), ModBlocks.createDenseOre("boron_ore", "oreBoron").stats(0, 32, 20), ModBlocks.createDenseOre("thorium_ore", "oreThorium").stats(0, 32, 20), ModBlocks.createDenseOre("beryllium_ore", "oreBeryllium").stats(0, 128, 20), ModBlocks.createDenseOre("cadmium_ore", "oreCadmium").stats(0, 96, 20), ModBlocks.createDenseOre("chromium_ore", "oreChromium").stats(0, 32, 20), ModBlocks.createDenseOre("magnesium_ore", "oreMagnesium").stats(0, 96, 20), ModBlocks.createDenseOre("manganese_ore", "oreManganese").stats(0, 64, 20), ModBlocks.createDenseOre("osmium_ore", "oreOsmium").stats(0, 96, 20), ModBlocks.createDenseOre("plutonium_ore", "orePlutonium").stats(0, 32, 20), ModBlocks.createDenseOre("rutile_ore", "oreRutile").stats(0, 64, 20), ModBlocks.createDenseOre("tantalum_ore", "oreTantalum").stats(0, 64, 20), ModBlocks.createDenseOre("tungsten_ore", "oreTungsten").stats(0, 32, 20), ModBlocks.createDenseOre("uranium_ore", "oreUranium").stats(0, 32, 20), ModBlocks.createDenseOre("zirconium_ore", "oreZirconium").stats(0, 0, 0)});
    }

    @SubscribeEvent
    public static void registerI(RegistryEvent.Register<Item> e) {
        DENSE_ORES.forEach(b -> e.getRegistry().register(new ItemBlock((Block)b).setRegistryName(b.getRegistryName())));
    }

    private static BlockDenseOre createDenseOre(Block block) {
        return ModBlocks.createDenseOre(block.getRegistryName().func_110623_a(), block.func_176223_P());
    }

    private static BlockDenseOre createDenseOre(String name, IBlockState state) {
        BlockDenseOre bde = new BlockDenseOre(state);
        bde.setRegistryName("dense_" + name);
        bde.func_149663_c("densemetals." + bde.getRegistryName().func_110623_a());
        DENSE_ORES.add(bde);
        return bde;
    }

    private static BlockDenseOre createDenseOre(String name, String oreName) {
        return ModBlocks.createDenseOre(name, () -> {
            ItemStack stack = ModBlocks.getStackFromDictWithPreference(DenseMetalsConfig.prefModid, oreName);
            if (stack.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                IBlockState state = null;
                try {
                    state = block.getStateForPlacement(null, BlockPos.field_177992_a, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), null, EnumHand.MAIN_HAND);
                }
                catch (Exception e) {
                    state = block.func_176203_a(stack.func_77960_j());
                }
                return state;
            }
            return null;
        });
    }

    private static BlockDenseOre createDenseOre(String name, Supplier<IBlockState> state) {
        BlockDenseOre bde = new BlockDenseOre(state);
        bde.setRegistryName("dense_" + name);
        bde.func_149663_c("densemetals." + bde.getRegistryName().func_110623_a());
        DENSE_ORES.add(bde);
        return bde;
    }

    public static ItemStack getStackFromDictWithPreference(String domain, String ore) {
        ItemStack stack = ItemStack.field_190927_a;
        Iterator iterator = OreDictionary.getOres((String)ore, (boolean)false).iterator();
        while (iterator.hasNext()) {
            ItemStack is;
            stack = is = (ItemStack)iterator.next();
            if (!is.func_77973_b().getRegistryName().func_110624_b().equals(domain)) continue;
            break;
        }
        return stack;
    }
}

