/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import jackyy.dimensionaledibles.DimensionalEdibles;
import jackyy.dimensionaledibles.block.BlockCakeBase;
import jackyy.dimensionaledibles.block.tile.TileDimensionCake;
import jackyy.dimensionaledibles.item.ItemBlockCustomCake;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.Cache;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class BlockCustomCake
extends BlockCakeBase
implements ITileEntityProvider {
    private int cakeDimension;
    private static Cache<Integer, CustomCake> cache = new Cache();
    private final ModConfig.CakeConfig conf = new ModConfig.CakeConfig(){

        @Override
        public String fuel(int dim) {
            return cache.getPropertyIfPresentOrNull(dim, c -> ((CustomCake)c).cakeFuel);
        }

        @Override
        public boolean useCustomCoordinates(int dim) {
            return cache.getPropertyIfPresentOrElse(dim, c -> {
                ModConfig.CustomCoords cc = c.customCoords;
                return cc.x != 0.0 || cc.y != 0.0 || cc.z != 0.0;
            }, () -> false);
        }

        @Override
        public ModConfig.CustomCoords customCoords(int dim) {
            return cache.getPropertyIfPresentOrElse(dim, c -> c.customCoords, () -> new CustomCake((int)dim).customCoords);
        }

        @Override
        public boolean consumesFuel() {
            return ModConfig.tweaks.customEdible.customCake.consumeFuel;
        }

        @Override
        public boolean preFueled() {
            return ModConfig.tweaks.customEdible.customCake.preFueled;
        }
    };

    public BlockCustomCake() {
        this.setRegistryName("dimensionaledibles:custom_cake");
        this.func_149663_c("dimensionaledibles.custom_cake");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int dim = this.getDimension(world, pos);
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            FormattedMessage message = new FormattedMessage("Requested dimension: \"{}\" does not exist. Please verify your configs.", (Object)dim);
            if (!world.field_72995_K) {
                DimensionalEdibles.logger.error((Message)message);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(message.getFormattedMessage()));
            }
            return true;
        }
        this.cakeDimension = dim;
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    private int getDimension(World world, BlockPos pos) {
        TileEntity ent = world.func_175625_s(pos);
        if (ent instanceof TileDimensionCake) {
            return ((TileDimensionCake)ent).getDimensionID();
        }
        throw new IllegalArgumentException("Specified position does not contain a Custom Cake");
    }

    public static void rebuildCache() {
        CustomCake cake;
        int dim;
        String[] parts;
        Cache<Integer, CustomCake> newCache = new Cache<Integer, CustomCake>();
        NonNullList subBlocks = NonNullList.func_191196_a();
        new BlockCustomCake().func_149666_a(CreativeTabs.field_78030_b, (NonNullList<ItemStack>)subBlocks);
        for (ItemStack stack : subBlocks) {
            int dimID = ItemBlockCustomCake.getDimID(stack);
            newCache.putIfAbsent(dimID, new CustomCake(dimID));
        }
        for (String s : ModConfig.tweaks.customEdible.customCoords) {
            try {
                parts = s.split(",");
                if (parts.length < 4) {
                    DimensionalEdibles.logger.error("\"{}\" is not a valid input line! Format needs to be: <dimID>, <x>, <y>, <z>", (Object)s);
                    continue;
                }
                dim = Integer.parseInt(parts[0].trim());
                if (!newCache.containsKey(dim)) {
                    DimensionalEdibles.logger.error("Unrecognized dimension: \"{}\"", (Object)dim);
                    return;
                }
                cake = (CustomCake)newCache.get(dim);
                ModConfig.CustomCoords cc = cake.customCoords;
                cc.x = Integer.parseInt(parts[1].trim());
                cc.y = Integer.parseInt(parts[2].trim());
                cc.z = Integer.parseInt(parts[3].trim());
            }
            catch (NumberFormatException e) {
                DimensionalEdibles.logger.error("\"{}\" is not a valid line input! The dimension ID needs to be a number!", (Object)s, (Object)e);
                return;
            }
        }
        for (String s : ModConfig.tweaks.customEdible.customCake.fuel) {
            try {
                parts = s.split(",");
                if (parts.length < 2) {
                    DimensionalEdibles.logger.error("\"{}\" is not a valid input line! Format needs to be: <dimID>, <cakeFuel>", (Object)s);
                    return;
                }
                dim = Integer.parseInt(parts[0].trim());
                cake = (CustomCake)newCache.get(dim);
                cake.cakeFuel = parts[1].trim();
            }
            catch (NumberFormatException e) {
                DimensionalEdibles.logger.error("\"{}\" is not a valid line input! The dimension ID needs to be a number!", (Object)s, (Object)e);
                return;
            }
        }
        cache = newCache;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.registerItem()) {
            for (String s : ModConfig.tweaks.customEdible.dimensions) {
                try {
                    String[] parts = s.split(",");
                    if (parts.length < 2) {
                        DimensionalEdibles.logger.error("\"{}\" is not a valid input line! Format needs to be: <dimID>, <cakeName>", (Object)s);
                        continue;
                    }
                    int dimension = Integer.parseInt(parts[0].trim());
                    ItemStack stack = new ItemStack((Block)this);
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                        stack.func_77982_d(nbt);
                    }
                    nbt.func_74768_a("dimID", dimension);
                    nbt.func_74778_a("cakeName", parts[1].trim());
                    list.add((Object)stack);
                }
                catch (NumberFormatException e) {
                    DimensionalEdibles.logger.error("\"{}\" is not a valid line input! The dimension ID needs to be a number!", (Object)s, (Object)e);
                }
            }
        }
    }

    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileDimensionCake();
    }

    @Override
    protected ModConfig.CakeConfig config() {
        return this.conf;
    }

    @Override
    public boolean registerItem() {
        return ModConfig.general.customCake;
    }

    @Override
    public int cakeDimension() {
        return this.cakeDimension;
    }

    @Override
    @Nonnull
    public ItemStack defaultFuel() {
        return ItemStack.field_190927_a;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        this.cakeDimension = this.getDimension(world, data.getPos());
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        this.cakeDimension = this.getDimension(accessor.getWorld(), accessor.getPosition());
        return super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    private static class CustomCake {
        public ModConfig.CustomCoords customCoords = new ModConfig.CustomCoords(0.0, 0.0, 0.0);
        private String cakeFuel = null;
        private final int cakeDimension;

        public CustomCake(int dim) {
            this.cakeDimension = dim;
        }

        public String toString() {
            return String.format("CustomCake[dim: %d, fuel: %s, coords: %s]", this.cakeDimension, this.cakeFuel, this.customCoords);
        }
    }
}

