/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.swing;

import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.minecraft.util.StringUtils;

public class UIAddBranch
extends JFrame
implements ActionListener {
    private final TreeBranchRoot parentBranch;
    private List<String> categories;
    private String parentID;
    private List<String> activeIDs;
    private JPanel contentPane;
    private JPanel buttonPane;
    private JButton cancelButton;
    private JButton createButton;
    private JPanel namePanel;
    private JTextField nameField;
    private JPanel categoryPanel;
    private JTextField categoryField;
    private JComboBox selectCategory;
    private JTextArea categoryDescription;
    private JTextField idField;
    private JLabel idLabel;

    public UIAddBranch(TreeBranchRoot parent, List<String> categories, final String parentID, List<String> activeIDs) {
        this.parentBranch = parent;
        this.categories = categories;
        this.parentID = parentID;
        this.activeIDs = activeIDs;
        this.setupUI();
        this.setTitle("Add Branch");
        this.setDefaultCloseOperation(2);
        this.createButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.selectCategory.addActionListener(this);
        this.idLabel.setText(parentID + (this.parentBranch.isModBranch ? ":" : "/"));
        this.idField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UIAddBranch.this.idLabel.setText(parentID + (((UIAddBranch)UIAddBranch.this).parentBranch.isModBranch ? ":" : "/") + UIAddBranch.this.idField.getText());
            }
        });
    }

    private void setupUI() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridLayoutManager(5, 1, new Insets(10, 10, 10, 10), -1, -1));
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)this.buttonPane, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.buttonPane.add((Component)this.cancelButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.buttonPane.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.createButton = new JButton();
        this.createButton.setText("Create");
        this.buttonPane.add((Component)this.createButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)this.namePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.namePanel.setBorder(BorderFactory.createTitledBorder("Name Branch"));
        this.nameField = new JTextField();
        this.namePanel.add((Component)this.nameField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.categoryPanel = new JPanel();
        this.categoryPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)this.categoryPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.categoryPanel.setBorder(BorderFactory.createTitledBorder("Set Category "));
        this.categoryField = new JTextField();
        this.categoryPanel.add((Component)this.categoryField, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.selectCategory = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        for (String cat : this.categories) {
            defaultComboBoxModel1.addElement(cat);
        }
        this.selectCategory.setModel(defaultComboBoxModel1);
        this.categoryPanel.add((Component)this.selectCategory, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.categoryDescription = new JTextArea();
        this.categoryDescription.setEditable(false);
        this.categoryDescription.setText("You can select a pre-existing category or create your own.\nNote for items and blocks you should use the built in categories.\nThe built in categories will automaticly be localized if localization is avalible.\nIf localization is not avalible for your language feel free to help out by\nadding or updating the lang file for your language. If you do not know how\nthen ether leave it for someone else or create an issue on github and ask for\nhelp.  ");
        this.categoryPanel.add((Component)this.categoryDescription, new GridConstraints(1, 0, 1, 2, 0, 3, 4, 4, null, new Dimension(150, 50), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel1.setBorder(BorderFactory.createTitledBorder("Branch ID"));
        this.idField = new JTextField();
        panel1.add((Component)this.idField, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JTextArea idDescription = new JTextArea();
        idDescription.setEditable(false);
        idDescription.setText("Branch ID is an id that is completely uniqe to this branch.\nIt is made up of a combination of the modid and its parent branch id's \n(if it has parent branches) and the id you specify here. \nThat means the id you specify here does not need to be too special \nas long as it does not conflict with any other id's in this branch. \nFor items and blocks its a good idea to use the item or block's registry name\n(not including modid) You will get an error if the id you choos is already in use.");
        panel1.add((Component)idDescription, new GridConstraints(2, 0, 1, 1, 0, 3, 4, 4, null, new Dimension(150, 50), null, 0, false));
        this.idLabel = new JLabel();
        this.idLabel.setText("");
        panel1.add((Component)this.idLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.contentPane.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.setContentPane(this.contentPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("comboBoxChanged")) {
            String selected = this.selectCategory.getSelectedItem().toString();
            this.categoryField.setText(selected);
        }
        if (command.equals("Create")) {
            int reply;
            if (StringUtils.func_151246_b((String)this.nameField.getText())) {
                JOptionPane.showMessageDialog(this, "The name field can not be empty", "Error", 0);
                return;
            }
            if (StringUtils.func_151246_b((String)this.idField.getText())) {
                JOptionPane.showMessageDialog(this, "The id field can not be empty", "Error", 0);
                return;
            }
            if (this.activeIDs.contains(this.parentID + (this.parentBranch.isModBranch ? ":" : "/") + this.idField.getText())) {
                JOptionPane.showMessageDialog(this, "That ID is already in use in this branch", "Error", 0);
                return;
            }
            if (StringUtils.func_151246_b((String)this.categoryField.getText()) && (reply = JOptionPane.showOptionDialog(this, "Are you sure you want to leave the category field empty? I wont stop you but you may want to re consider.", "Are you sure?", 0, 2, null, new Object[]{"Yes", "No"}, "No")) == 1) {
                return;
            }
            TreeBranchRoot treeBranchRoot = this.parentBranch;
            synchronized (treeBranchRoot) {
                this.parentBranch.createNewSubBranch(this.nameField.getText(), this.idField.getText(), this.categoryField.getText(), this.parentBranch);
            }
            this.dispose();
        }
        if (command.equals("Cancel")) {
            this.dispose();
        }
    }
}

