/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;

public class Alias
extends AbstractConditional {
    private Optional<String> name = this.empty();
    private Optional<String> item = this.empty();

    @Override
    public String getName() {
        return this.get(this.name);
    }

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.name.isPresent()) {
                throw new InvalidRecipeConfigException("Missing name");
            }
            if (!this.item.isPresent()) {
                throw new InvalidRecipeConfigException("Missing item");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in alias '" + this.item.orElse("(missing item)") + "'");
        }
        if (this.isActive()) {
            Things.addAlias((String)this.get(this.name), (String)this.get(this.item));
            Log.debug("Added alias '" + this.name.get() + "' => '" + this.item.get() + "'");
        }
        return this;
    }

    @Override
    public void register(@Nonnull String recipeName, @Nonnull RecipeLevel recipeLevel) {
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = this.ofString(value);
            return true;
        }
        if ("item".equals(name)) {
            this.item = this.ofString(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }

    protected String getItem() {
        return this.get(this.item);
    }
}

