/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeOutput {
    @Nullable
    private final FluidStack outputFluid;
    @Nonnull
    private final ItemStack output;
    private final float chance;
    private final float exp;

    public RecipeOutput(@Nonnull Block output) {
        this(new ItemStack(output), 1.0f);
    }

    public RecipeOutput(@Nonnull Block output, float chance) {
        this(new ItemStack(output), chance);
    }

    public RecipeOutput(@Nonnull Item output, float chance) {
        this(new ItemStack(output), chance);
    }

    public RecipeOutput(@Nonnull Item output) {
        this(new ItemStack(output), 1.0f);
    }

    public RecipeOutput(@Nonnull ItemStack output) {
        this(output, 1.0f);
    }

    public RecipeOutput(@Nonnull ItemStack output, float chance) {
        this(output, chance, 0.0f);
    }

    public RecipeOutput(@Nonnull ItemStack output, float chance, float exp) {
        this.output = output.func_77946_l();
        this.chance = chance;
        this.exp = exp;
        this.outputFluid = null;
    }

    public RecipeOutput(@Nonnull FluidStack output) {
        this.outputFluid = output;
        this.output = Prep.getEmpty();
        this.chance = 1.0f;
        this.exp = 0.0f;
    }

    public float getChance() {
        return this.chance;
    }

    public float getExperiance() {
        return this.exp;
    }

    @Nonnull
    public ItemStack getOutput() {
        return this.output;
    }

    @Nullable
    public FluidStack getFluidOutput() {
        return this.outputFluid;
    }

    public boolean isFluid() {
        return this.outputFluid != null;
    }

    public boolean isValid() {
        return Prep.isValid(this.output) || this.outputFluid != null && this.outputFluid.getFluid() != null;
    }

    public String toString() {
        return "RecipeOutput [output=" + (this.isFluid() ? this.outputFluid : this.output) + (this.chance != 1.0f ? ", chance=" + this.chance : "") + (this.exp != 0.0f ? ", exp=" + this.exp : "") + "]";
    }
}

