/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.server;

import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.base.invpanel.database.ItemEntryBase;
import crazypants.enderio.base.invpanel.database.SlotKey;
import java.util.IdentityHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class ItemEntry
extends ItemEntryBase
implements IServerItemEntry {
    private final IdentityHashMap<SlotKey, SlotKey> slots = new IdentityHashMap();

    public ItemEntry(int dbID, int hash, int itemID, int meta, NBTTagCompound nbt) {
        super(dbID, hash, itemID, meta, nbt);
    }

    @Override
    public void addSlot(SlotKey slotKey) {
        this.slots.put(slotKey, slotKey);
    }

    @Override
    public void removeSlot(SlotKey slotKey) {
        this.slots.remove(slotKey);
    }

    @Override
    public int countItems() {
        int count = 0;
        for (SlotKey slotKey : this.slots.values()) {
            count += slotKey.count;
        }
        return count;
    }

    @Override
    public int extractItems(@Nonnull IInventoryDatabaseServer db, int count) {
        SlotKey[] copy;
        int extracted = 0;
        for (SlotKey slotKey : copy = this.slots.values().toArray(new SlotKey[this.slots.size()])) {
            int amount = slotKey.inv.extractItem(db, this, slotKey.slot, count);
            extracted += amount;
            if ((count -= amount) <= 0) break;
        }
        return extracted;
    }
}

