/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.sagmill;

import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.task.PoweredTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.sagmill.IGrindingMultiplier;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.sagmill.PacketGrindingBall;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

@Storable
public abstract class TileSagMill
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Store
    protected IGrindingMultiplier grindingBall;
    @Store
    protected int grindingBallDurabilityUsed = 0;
    @Store
    protected int grindingBallDurabilityMax = 0;
    @Store
    protected int lastSendGbScaled = 0;

    protected TileSagMill(@Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "sagmill";
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return Prep.isValid(itemstack) && SagMillRecipeManager.getInstance().isValidInput(this.getMachineLevel(), new MachineRecipeInput(i, itemstack));
    }

    public int getBallDurationScaled(int scale) {
        return MathHelper.func_76125_a((int)(this.grindingBallDurabilityMax > 0 ? (int)((float)scale * (1.0f - (float)this.grindingBallDurabilityUsed / (float)this.grindingBallDurabilityMax)) : 0), (int)0, (int)scale);
    }

    @Override
    protected int usePower(int wantToUse) {
        int res = super.usePower(wantToUse);
        if (this.currentTask != null && this.currentTask.getBonusType().useBalls()) {
            boolean sendGB = false;
            if (this.grindingBall != null) {
                this.grindingBallDurabilityUsed += res;
                if (this.grindingBallDurabilityUsed >= this.grindingBallDurabilityMax) {
                    this.grindingBallDurabilityUsed -= this.grindingBallDurabilityMax;
                    this.grindingBallDurabilityMax = 0;
                    this.grindingBall = null;
                    sendGB = true;
                } else {
                    int newScaled = this.getBallDurationScaled(16);
                    if (newScaled != this.lastSendGbScaled) {
                        sendGB = true;
                    }
                }
            }
            if (this.grindingBall == null) {
                ItemStack ballInSlot = this.getStackInSlot(1);
                this.grindingBall = SagMillRecipeManager.getInstance().getGrindballFromStack(ballInSlot);
                if (this.grindingBall != null) {
                    this.grindingBallDurabilityMax = this.grindingBall.getDurability();
                    ballInSlot.func_190918_g(1);
                    this.func_70296_d();
                    sendGB = false;
                }
            }
            if (sendGB) {
                PacketHandler.sendToAllAround(new PacketGrindingBall(this), (TileEntity)this);
                this.lastSendGbScaled = this.getBallDurationScaled(16);
            }
        }
        return res;
    }

    @Override
    protected IPoweredTask createTask(@Nonnull IMachineRecipe nextRecipe, long nextSeed) {
        PoweredTask res;
        if (this.grindingBall != null && nextRecipe.getBonusType(this.getRecipeInputs()).doChances()) {
            res = new PoweredTask(nextRecipe, nextSeed, this.grindingBall.getGrindingMultiplier(), this.grindingBall.getChanceMultiplier(), this.getRecipeInputs());
            res.setRequiredEnergy(res.getRequiredEnergy() * this.grindingBall.getPowerMultiplier());
        } else {
            res = new PoweredTask(nextRecipe, nextSeed, this.getRecipeInputs());
        }
        return res;
    }

    @Override
    public ResourceLocation getSound() {
        return new ResourceLocation("enderio", "machine.sagmill");
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 0.125f;
    }

    @Storable
    public static class Enhanced
    extends TileSagMill {
        public Enhanced() {
            super(new SlotDefinition(2, 4), CapacitorKey.ENHANCED_SAG_MILL_POWER_INTAKE, CapacitorKey.ENHANCED_SAG_MILL_POWER_BUFFER, CapacitorKey.ENHANCED_SAG_MILL_POWER_USE);
            this.setEfficiencyMultiplier(CapacitorKey.ENHANCED_SAG_MILL_POWER_EFFICIENCY);
        }

        @Override
        @Nonnull
        public ICapacitorData getCapacitorData() {
            return CapacitorHelper.increaseCapacitorLevel(super.getCapacitorData(), 1.0f);
        }

        @Override
        protected boolean shouldDoubleTick(@Nonnull IPoweredTask task, int usedEnergy) {
            double chance = this.getCapacitorData().getUnscaledValue(CapacitorKey.ENHANCED_SAG_MILL_DOUBLE_OP_CHANCE) * ((float)usedEnergy / task.getRequiredEnergy());
            if (this.random.nextDouble() < chance) {
                return true;
            }
            return super.shouldDoubleTick(task, usedEnergy);
        }

        @Override
        public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
            return (faceHit != EnumFacing.UP || mode == IoMode.NONE) && super.supportsMode(faceHit, mode);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return RecipeLevel.ADVANCED;
        }
    }

    @Storable
    public static class Normal
    extends TileSagMill {
        public Normal() {
            super(new SlotDefinition(2, 4), CapacitorKey.SAG_MILL_POWER_INTAKE, CapacitorKey.SAG_MILL_POWER_BUFFER, CapacitorKey.SAG_MILL_POWER_USE);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return RecipeLevel.NORMAL;
        }
    }

    @Storable
    public static class Simple
    extends TileSagMill {
        public Simple() {
            super(new SlotDefinition(2, 4, 0), CapacitorKey.SIMPLE_SAG_MILL_POWER_INTAKE, CapacitorKey.SIMPLE_SAG_MILL_POWER_BUFFER, CapacitorKey.SIMPLE_SAG_MILL_POWER_USE);
            this.setEnergyLoss(CapacitorKey.SIMPLE_SAG_MILL_POWER_LOSS);
        }

        @Override
        public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
            return i != 1 && super.isMachineItemValidForSlot(i, itemstack);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return RecipeLevel.SIMPLE;
        }
    }
}

