/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.combinationcrafting;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

@MethodsReturnNonnullByDefault
public class CombinationCraftingWrapper
implements IRecipeWrapper {
    private final ITickTimer timer;
    private final IJeiHelpers helpers;
    private final CombinationRecipe recipe;

    public CombinationCraftingWrapper(IJeiHelpers helpers, CombinationRecipe recipe) {
        this.helpers = helpers;
        this.recipe = recipe;
        int period = recipe.getPedestalIngredients().stream().map(Ingredient::func_193365_a).map(a -> ((ItemStack[])a).length).reduce(1, (a, b) -> a * b);
        this.timer = helpers.getGuiHelper().createTickTimer(period * 20, period, false);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 1 && mouseX < 14 && mouseY > 9 && mouseY < 86) {
            return Arrays.asList(Utils.format((Object)this.recipe.getCost()) + " FE", Utils.format((Object)this.recipe.getPerTick()) + " FE/t");
        }
        if (mouseX > 5 && mouseX < 23 && mouseY > 144 && mouseY < 165) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(Utils.localize((String)"tooltip.ec.items_required"));
            Object2IntLinkedOpenHashMap tooltipCount = new Object2IntLinkedOpenHashMap();
            for (Ingredient ing : this.recipe.getPedestalIngredients()) {
                ItemStack[] stacks = ing.func_193365_a();
                if (stacks.length == 0) continue;
                String line = stacks[this.timer.getValue() % stacks.length].func_82833_r();
                tooltipCount.put((Object)line, tooltipCount.getInt((Object)line) + 1);
            }
            tooltipCount.forEach((string, count) -> tooltip.add(String.format(" %dx %s", count, string)));
            return tooltip;
        }
        return Collections.emptyList();
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper helper = this.helpers.getStackHelper();
        ItemStack output = this.recipe.getOutput();
        ArrayList<List> inputs = new ArrayList<List>();
        inputs.add(helper.toItemStackList((Object)this.recipe.getInputIngredient()));
        inputs.addAll(helper.expandRecipeItemStackInputs(this.recipe.getPedestalIngredients()));
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }
}

