/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.search.GeneralizedSuffixTree;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.LimitedStringStorage;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;

public class PrefixInfo
implements Comparable<PrefixInfo> {
    public static final PrefixInfo NO_PREFIX;
    private static final Char2ObjectMap<PrefixInfo> instances;
    private final char prefix;
    private final int priority;
    private final boolean potentialDialecticInclusion;
    private final String desc;
    private final IModeGetter modeGetter;
    private final IStringsGetter stringsGetter;
    private final Supplier<ISearchStorage<IIngredientListElement<?>>> storage;

    private static void addPrefix(PrefixInfo info) {
        instances.put(info.getPrefix(), (Object)info);
    }

    public static Collection<PrefixInfo> all() {
        return Collections.unmodifiableCollection(instances.values());
    }

    public static PrefixInfo get(char ch) {
        return (PrefixInfo)instances.get(ch);
    }

    public PrefixInfo(char prefix, int priority, boolean potentialDialecticInclusion, String desc, IModeGetter modeGetter, IStringsGetter stringsGetter, Supplier<ISearchStorage<IIngredientListElement<?>>> storage) {
        this.prefix = prefix;
        this.priority = priority;
        this.potentialDialecticInclusion = potentialDialecticInclusion;
        this.desc = desc;
        this.modeGetter = modeGetter;
        this.stringsGetter = stringsGetter;
        this.storage = storage;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean hasPotentialDialecticInclusion() {
        return this.potentialDialecticInclusion;
    }

    public String getDesc() {
        return this.desc;
    }

    public Config.SearchMode getMode() {
        return this.modeGetter.getMode();
    }

    public ISearchStorage<IIngredientListElement<?>> createStorage() {
        return this.storage.get();
    }

    public Collection<String> getStrings(IIngredientListElement<?> element) {
        if (!Config.getSearchStrippedDiacritics() || !this.potentialDialecticInclusion) {
            return this.stringsGetter.getStrings(element);
        }
        Collection<String> strings = this.stringsGetter.getStrings(element);
        for (String string : strings) {
            String stripped;
            boolean hasNonAscii = false;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) <= '\u007f') continue;
                hasNonAscii = true;
                break;
            }
            if (!hasNonAscii || (stripped = StringUtil.stripAccents(string)).equals(string)) continue;
            try {
                strings.add(stripped);
            }
            catch (UnsupportedOperationException e) {
                strings = new ArrayList<String>(strings);
                strings.add(StringUtil.stripAccents(string));
            }
        }
        return strings;
    }

    @Override
    public int compareTo(PrefixInfo o) {
        return Integer.compare(o.priority, this.priority);
    }

    public String toString() {
        return "PrefixInfo{" + this.desc + '}';
    }

    static {
        instances = new Char2ObjectArrayMap(6);
        NO_PREFIX = new PrefixInfo('\u0000', -1, true, "default", () -> Config.SearchMode.ENABLED, i -> Collections.singleton(Translator.toLowercaseWithLocale(i.getDisplayName())), GeneralizedSuffixTree::new);
        PrefixInfo.addPrefix(new PrefixInfo('#', 0, true, "tooltip", Config::getTooltipSearchMode, IIngredientListElement::getTooltipStrings, GeneralizedSuffixTree::new));
        PrefixInfo.addPrefix(new PrefixInfo('&', 1, false, "resource_id", Config::getResourceIdSearchMode, e -> Collections.singleton(e.getResourceId()), GeneralizedSuffixTree::new));
        PrefixInfo.addPrefix(new PrefixInfo('^', 2, true, "color", Config::getColorSearchMode, IIngredientListElement::getColorStrings, LimitedStringStorage::new));
        PrefixInfo.addPrefix(new PrefixInfo('$', 3, false, "oredict", Config::getOreDictSearchMode, IIngredientListElement::getOreDictStrings, LimitedStringStorage::new));
        PrefixInfo.addPrefix(new PrefixInfo('@', 4, false, "mod_name", Config::getModNameSearchMode, IIngredientListElement::getModNameStrings, LimitedStringStorage::new));
        PrefixInfo.addPrefix(new PrefixInfo('%', 5, true, "creative_tab", Config::getCreativeTabSearchMode, IIngredientListElement::getCreativeTabsStrings, LimitedStringStorage::new));
    }

    @FunctionalInterface
    public static interface IModeGetter {
        public Config.SearchMode getMode();
    }

    @FunctionalInterface
    public static interface IStringsGetter {
        public Collection<String> getStrings(IIngredientListElement<?> var1);
    }
}

