/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public class LittleActionCombined
extends LittleAction {
    public LittleAction[] actions;

    public LittleActionCombined(LittleAction ... actions) {
        this.actions = actions;
    }

    public LittleActionCombined() {
    }

    @Override
    public boolean canBeReverted() {
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i].canBeReverted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public LittleAction revert(EntityPlayer player) throws LittleActionException {
        LittleAction[] newActions = new LittleAction[this.actions.length];
        for (int i = 0; i < newActions.length; ++i) {
            if (this.actions[this.actions.length - 1 - i] == null) continue;
            newActions[i] = this.actions[this.actions.length - 1 - i].revert(player);
        }
        return new LittleActionCombined(newActions);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        if (this.actions.length == 0) {
            return true;
        }
        boolean success = false;
        for (int i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] == null || !this.actions[i].action(player)) continue;
            success = true;
        }
        return success;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.actions.length);
        for (int i = 0; i < this.actions.length; ++i) {
            buf.writeInt(CreativeCorePacket.getId((CreativeCorePacket)this.actions[i]));
            this.actions[i].writeBytes(buf);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.actions = new LittleAction[buf.readInt()];
        for (int i = 0; i < this.actions.length; ++i) {
            int id = buf.readInt();
            Class PacketClass = CreativeCorePacket.getClass((int)id);
            LittleAction packet = null;
            try {
                packet = (LittleAction)((Object)PacketClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                System.out.println("Invalid packet id=" + id);
            }
            packet.readBytes(buf);
            this.actions[i] = packet;
        }
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        LittleAction[] newActions = new LittleAction[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            newActions[i] = this.actions[i].flip(axis, box);
        }
        return new LittleActionCombined(newActions);
    }
}

