/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.api.ILittleTool;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ILittlePlacer
extends ILittleTool {
    public boolean hasLittlePreview(ItemStack var1);

    public LittlePreviews getLittlePreview(ItemStack var1);

    default public LittlePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution) {
        return this.getLittlePreview(stack);
    }

    public void saveLittlePreview(ItemStack var1, LittlePreviews var2);

    @Override
    default public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation, boolean client) {
        LittlePreviews previews = this.getLittlePreview(stack, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotatePreviews(rotation, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    @Override
    default public void flip(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, boolean client) {
        LittlePreviews previews = this.getLittlePreview(stack, false);
        if (previews.isEmpty()) {
            return;
        }
        previews.flipPreviews(axis, previews.getContext().rotationCenter);
        this.saveLittlePreview(stack, previews);
    }

    default public LittleGridContext getPreviewsContext(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleGridContext.get(stack.func_77978_p());
        }
        return LittleGridContext.get();
    }

    public boolean containsIngredients(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    default public float getPreviewAlphaFactor() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldCache() {
        return true;
    }

    default public PlacementMode getPlacementMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return PlacementMode.getModeOrDefault(stack.func_77978_p().func_74779_i("mode"));
        }
        return PlacementMode.getDefault();
    }

    default public boolean snapToGridByDefault(ItemStack stack) {
        return false;
    }

    default public LittleVec getCachedSize(ItemStack stack) {
        return null;
    }

    default public LittleVec getCachedOffset(ItemStack stack) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public List<LittleRenderBox> getPositingCubes(World world, BlockPos pos, ItemStack stack) {
        LittleStructureType type;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structure") && (type = LittleStructureRegistry.getStructureType(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"))) != null) {
            return type.getPositingCubes(world, pos, stack);
        }
        return null;
    }
}

