/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.SignalUtils;
import com.creativemd.littletiles.common.structure.signal.logic.SignalCondition;

public class SignalConditionExternal
extends SignalCondition.SignalConditionInput {
    public SignalConditionExternal(int id) {
        super(id);
    }

    @Override
    public void test(LittleStructure structure, boolean[] state) {
        SignalUtils.combine(state, SignalUtils.getInputState((LittleStructure)structure, (int)this.childId, (boolean)true));
    }

    @Override
    public String write() {
        return "i" + this.childId;
    }

    public static class SignalConditionExternalExact
    extends SignalCondition.SignalConditionInput {
        public int[] indexes;

        public SignalConditionExternalExact(int id, int[] indexes) {
            super(id);
            this.indexes = indexes;
        }

        @Override
        public void test(LittleStructure structure, boolean[] state) {
            boolean found = SignalUtils.is(SignalUtils.getInputState((LittleStructure)structure, (int)this.childId, (boolean)true), this.indexes);
            for (int i = 0; i < state.length; ++i) {
                state[i] = found;
            }
        }

        @Override
        public String write() {
            String result = "i" + this.childId + "{";
            for (int i = 0; i < this.indexes.length; ++i) {
                int index = this.indexes[i];
                if (index < 0) {
                    result = result + ",";
                }
                result = result + (char)index;
            }
            return result + "}";
        }
    }
}

