/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic.event;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.SignalUtils;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import java.text.ParseException;

public abstract class SignalOutputCondition {
    public final int output;
    public final boolean external;
    public final int index;

    public SignalOutputCondition(int output, boolean external, int index) {
        this.output = output;
        this.external = external;
        this.index = index;
    }

    public abstract SignalMode getMode();

    public void setState(LittleStructure structure, boolean[] state) {
        ISignalComponent component = SignalUtils.getOutput(structure, this.output, this.external);
        if (component != null) {
            component.updateState(state);
        }
    }

    public int getBandwidth(LittleStructure structure) {
        if (this.index != -1) {
            return 1;
        }
        ISignalComponent component = SignalUtils.getOutput(structure, this.output, this.external);
        if (component != null) {
            return component.getBandwidth();
        }
        return 0;
    }

    public String write() {
        String result = (this.external ? "o" : "b") + this.output;
        if (this.index != -1) {
            result = result + "-" + this.index;
        }
        return result + this.getMode().splitter;
    }

    public static SignalOutputCondition create(String pattern, SignalMode mode) throws ParseException {
        int index;
        boolean external;
        SignalCondition.Parser parser = new SignalCondition.Parser(pattern);
        if (!parser.hasNext()) {
            throw new ParseException("Invalid output pattern " + pattern, parser.position());
        }
        char begin = parser.next();
        if (begin == 'o') {
            external = true;
        } else if (begin == 'b') {
            external = false;
        } else {
            throw new ParseException("Invalid pattern start " + pattern, parser.position());
        }
        int output = 0;
        if (Character.isDigit(parser.lookForNext())) {
            output = SignalCondition.parseDigit(parser.next(), parser);
        }
        if (parser.hasNext()) {
            char current = parser.next();
            if (current != '-') {
                throw new ParseException("Invalid char " + current, parser.position());
            }
            if (!parser.hasNext()) {
                throw new ParseException("Invalid output index " + pattern, parser.position());
            }
            index = SignalCondition.parseDigit(parser.next(), parser);
        } else {
            index = -1;
        }
        switch (mode) {
            case EQUAL: {
                return new SignalOutputConditionEqual(output, external, index);
            }
        }
        throw new ParseException("Invalid mode " + mode.name(), 0);
    }

    public static SignalOutputCondition create(int output, boolean external, int index, SignalMode mode) {
        switch (mode) {
            case EQUAL: {
                return new SignalOutputConditionEqual(output, external, index);
            }
        }
        throw new RuntimeException("Invalid mode " + mode.name());
    }

    public static class SignalOutputConditionPulse
    extends SignalOutputCondition {
        public SignalOutputConditionPulse(int output, boolean external, int index) {
            super(output, external, index);
        }

        @Override
        public SignalMode getMode() {
            return SignalMode.PULSE;
        }
    }

    public static class SignalOutputConditionToggle
    extends SignalOutputCondition {
        public SignalOutputConditionToggle(int output, boolean external, int index) {
            super(output, external, index);
        }

        @Override
        public SignalMode getMode() {
            return SignalMode.TOGGLE;
        }
    }

    public static class SignalOutputConditionEqual
    extends SignalOutputCondition {
        public SignalOutputConditionEqual(int output, boolean external, int index) {
            super(output, external, index);
        }

        @Override
        public SignalMode getMode() {
            return SignalMode.EQUAL;
        }
    }
}

