/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.client.render.tile.LittleRenderBoxItem;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleItemHolder
extends LittleStructurePremade {
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public EnumFacing facing;
    @StructureDirectional
    public Vector3f topRight;
    public ItemStack stack;

    public LittleItemHolder(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.stack = new ItemStack(nbt.func_74775_l("stack"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (worldIn.field_72995_K) {
            return true;
        }
        ItemStack mainStack = playerIn.func_184614_ca();
        if (mainStack.func_190926_b() && !this.stack.func_190926_b()) {
            playerIn.func_174820_d(playerIn.field_71071_by.field_70461_c, this.stack.func_77946_l());
            this.stack = ItemStack.field_190927_a;
            this.updateInput();
            this.updateStructure();
        } else if (this.stack.func_190926_b()) {
            playerIn.func_174820_d(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            this.stack = mainStack.func_77946_l();
            this.updateInput();
            this.updateStructure();
        }
        return true;
    }

    public void updateInput() {
        this.getInput(0).updateState(BooleanUtils.asArray((!this.stack.func_190926_b() ? 1 : 0) != 0));
    }

    @Override
    public void getRenderingCubes(BlockPos pos, BlockRenderLayer layer, List<LittleRenderBox> cubes) {
        if (layer == BlockRenderLayer.CUTOUT) {
            AlignedBox box = this.frame.getBox().getCube(this.frame.getContext());
            if (!this.stack.func_190926_b()) {
                cubes.add(new LittleRenderBoxItem(this, box, this.frame.getBox()));
            }
        }
    }
}

