/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.combine;

import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.combine.ICombinable;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import java.util.ArrayList;
import java.util.List;

public class AdvancedCombiner<T extends ICombinable>
extends BasicCombiner {
    protected List<T> tiles;
    protected T currentTile;

    public AdvancedCombiner(List<T> tiles) {
        super(new ArrayList());
        this.setCombinables(tiles);
    }

    public void setCombinables(List<T> tiles) {
        this.boxes.clear();
        for (ICombinable tile : tiles) {
            this.boxes.add(tile.getBox());
        }
        this.tiles = tiles;
    }

    public List<T> getCombinables() {
        return this.tiles;
    }

    public void onCombined(T first, T second) {
    }

    protected boolean shouldScan(T tile) {
        return true;
    }

    public boolean combine() {
        int sizeBefore = this.tiles.size();
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < this.tiles.size()) {
                if (!this.shouldScan((ICombinable)this.tiles.get(this.i))) {
                    ++this.i;
                    continue;
                }
                this.j = 0;
                while (this.j < this.tiles.size()) {
                    if (!this.shouldScan((ICombinable)this.tiles.get(this.j))) {
                        ++this.j;
                        continue;
                    }
                    if (this.i != this.j && ((ICombinable)this.tiles.get(this.i)).canCombine((ICombinable)this.tiles.get(this.j))) {
                        this.currentTile = (ICombinable)this.tiles.get(this.i);
                        LittleBox box = ((ICombinable)this.tiles.get(this.i)).getBox().combineBoxes(((ICombinable)this.tiles.get(this.j)).getBox(), this);
                        if (box != null) {
                            this.onCombined((ICombinable)this.tiles.get(this.i), (ICombinable)this.tiles.get(this.j));
                            ((ICombinable)this.tiles.get(this.i)).setBox(box);
                            this.tiles.remove(this.j);
                            this.boxes.set(this.i, box);
                            this.boxes.remove(this.j);
                            if (this.i > this.j) {
                                --this.i;
                            }
                            this.modified = true;
                            continue;
                        }
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        boolean changed = sizeBefore != this.tiles.size();
        this.tiles = null;
        this.currentTile = null;
        return changed;
    }

    protected void removeBox(int index) {
        super.removeBox(index);
        this.tiles.remove(index);
    }
}

