/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.shape;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.util.shape.LittleShape;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeBox;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeConnected;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeCurve;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeCurveWall;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeCylinder;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeInnerCorner;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeOuterCorner;
import com.creativemd.littletiles.common.util.shape.type.LittleShapePillar;
import com.creativemd.littletiles.common.util.shape.type.LittleShapePolygon;
import com.creativemd.littletiles.common.util.shape.type.LittleShapePyramid;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeSlice;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeSphere;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeTile;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeType;
import com.creativemd.littletiles.common.util.shape.type.LittleShapeWall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShapeRegistry {
    private static LinkedHashMap<String, LittleShape> shapes = new LinkedHashMap();
    private static HashMapList<ShapeType, String> shapeTypeLists = new HashMapList();
    private static List<String> noTileList = new ArrayList<String>();
    private static List<String> placingList = new ArrayList<String>();
    private static LittleShape defaultShape;
    public static LittleShape tileShape;

    public static Collection<LittleShape> shapes() {
        return shapes.values();
    }

    public static Collection<String> allShapeNames() {
        return shapes.keySet();
    }

    public static Collection<String> notTileShapeNames() {
        return noTileList;
    }

    public static Collection<String> placingShapeNames() {
        return placingList;
    }

    public static LittleShape registerShape(String id, LittleShape shape, ShapeType type) {
        shapes.put(id, shape);
        shapeTypeLists.add((Object)type, (Object)id);
        if (type != ShapeType.DEFAULT_SELECTOR) {
            noTileList.add(id);
        }
        placingList.clear();
        placingList.addAll(shapeTypeLists.getValuesOrEmpty((Object)ShapeType.SHAPE));
        placingList.addAll(shapeTypeLists.getValuesOrEmpty((Object)ShapeType.DEFAULT_SELECTOR));
        placingList.addAll(shapeTypeLists.getValuesOrEmpty((Object)ShapeType.SELECTOR));
        return shape;
    }

    public static LittleShape getShape(String name) {
        return shapes.getOrDefault(name, defaultShape);
    }

    public static String getShapeName(LittleShape shape) {
        for (Map.Entry<String, LittleShape> entry : shapes.entrySet()) {
            if (entry.getValue() != shape) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        tileShape = ShapeRegistry.registerShape("tile", new LittleShapeTile(), ShapeType.DEFAULT_SELECTOR);
        ShapeRegistry.registerShape("type", new LittleShapeType(), ShapeType.SELECTOR);
        defaultShape = ShapeRegistry.registerShape("box", new LittleShapeBox(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("connected", new LittleShapeConnected(), ShapeType.SELECTOR);
        ShapeRegistry.registerShape("slice", new LittleShapeSlice(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("inner_corner", new LittleShapeInnerCorner(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("outer_corner", new LittleShapeOuterCorner(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("polygon", new LittleShapePolygon(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("wall", new LittleShapeWall(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("pillar", new LittleShapePillar(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("curve", new LittleShapeCurve(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("curvewall", new LittleShapeCurveWall(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("cylinder", new LittleShapeCylinder(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("sphere", new LittleShapeSphere(), ShapeType.SHAPE);
        ShapeRegistry.registerShape("pyramid", new LittleShapePyramid(), ShapeType.SHAPE);
    }

    public static enum ShapeType {
        DEFAULT_SELECTOR,
        SELECTOR,
        SHAPE;

    }
}

