/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.networking;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import net.minecraft.item.ItemStack;
import thelm.packagedauto.integration.appeng.networking.HostHelperTile;
import thelm.packagedauto.tile.TilePackager;

public class HostHelperTilePackager
extends HostHelperTile<TilePackager> {
    public HostHelperTilePackager(TilePackager tile) {
        super(tile);
    }

    public void ejectItem() {
        IGrid grid = this.getNode().getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storageGrid == null) {
            return;
        }
        IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        if (energyGrid == null) {
            return;
        }
        IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
        IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)((TilePackager)this.tile).getInventory().func_70301_a(9));
        IAEItemStack rem = (IAEItemStack)AEApi.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, (IActionSource)this.source, Actionable.MODULATE);
        if (rem == null || rem.getStackSize() == 0L) {
            ((TilePackager)this.tile).getInventory().func_70299_a(9, ItemStack.field_190927_a);
        } else if (rem.getStackSize() < stack.getStackSize()) {
            ((TilePackager)this.tile).getInventory().func_70299_a(9, rem.createItemStack());
        }
    }

    public void chargeEnergy() {
        IGrid grid = this.getNode().getGrid();
        if (grid == null) {
            return;
        }
        IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        if (energyGrid == null) {
            return;
        }
        double energyRequest = (double)Math.min(((TilePackager)this.tile).getEnergyStorage().getMaxReceive(), ((TilePackager)this.tile).getEnergyStorage().getMaxEnergyStored() - ((TilePackager)this.tile).getEnergyStorage().getEnergyStored()) / 2.0;
        double canExtract = energyGrid.extractAEPower(energyRequest, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        double extract = (double)Math.round(canExtract * 2.0) / 2.0;
        ((TilePackager)this.tile).getEnergyStorage().receiveEnergy((int)Math.round(energyGrid.extractAEPower(extract, Actionable.MODULATE, PowerMultiplier.CONFIG) * 2.0), false);
    }

    public void postPatternChange() {
        IGrid grid = this.getNode().getGrid();
        if (grid == null) {
            return;
        }
        grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this.tile, this.getNode()));
    }
}

