/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TileUnpackager;

public class InventoryUnpackager
extends InventoryTileBase {
    public static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public final TileUnpackager tile;

    public InventoryUnpackager(TileUnpackager tile) {
        super(tile, 11);
        this.tile = tile;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (index == 9) {
            this.updateRecipeList();
        } else if (index != 10) {
            this.clearRejectedIndexes();
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        if (index == 9) {
            this.updateRecipeList();
        } else if (index != 10) {
            this.clearRejectedIndexes();
        }
        return stack;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 9: {
                return stack.func_77973_b() instanceof IRecipeListItem;
            }
            case 10: {
                return stack.hasCapability(CapabilityEnergy.ENERGY, null);
            }
        }
        return stack.func_77973_b() instanceof IPackageItem;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.updateRecipeList();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index != 9 && index != 10;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index != 9 && index != 10 && direction == EnumFacing.UP && !Arrays.stream(this.tile.trackers).anyMatch(t -> t.isEmpty());
    }

    public void updateRecipeList() {
        this.tile.recipeList.clear();
        ItemStack listStack = this.func_70301_a(9);
        if (listStack.func_77973_b() instanceof IRecipeListItem) {
            this.tile.recipeList.addAll(((IRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList());
        }
        if (this.tile.func_145831_w() != null && !this.tile.func_145831_w().field_72995_K && this.tile.hostHelper != null) {
            this.tile.hostHelper.postPatternChange();
        }
    }

    public void clearRejectedIndexes() {
        for (TileUnpackager.PackageTracker tracker : this.tile.trackers) {
            tracker.clearRejectedIndexes();
        }
    }
}

