/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.proxy;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.RecipeTypeRegistry;
import thelm.packagedauto.block.BlockCrafter;
import thelm.packagedauto.block.BlockEncoder;
import thelm.packagedauto.block.BlockPackager;
import thelm.packagedauto.block.BlockPackagerExtension;
import thelm.packagedauto.block.BlockUnpackager;
import thelm.packagedauto.config.PackagedAutoConfig;
import thelm.packagedauto.item.ItemMisc;
import thelm.packagedauto.item.ItemPackage;
import thelm.packagedauto.item.ItemRecipeHolder;
import thelm.packagedauto.network.GuiHandler;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.recipe.RecipeTypeCrafting;
import thelm.packagedauto.recipe.RecipeTypeProcessing;
import thelm.packagedauto.recipe.RecipeTypeProcessingOrdered;
import thelm.packagedauto.tile.TileCrafter;
import thelm.packagedauto.tile.TileEncoder;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;
import thelm.packagedauto.tile.TileUnpackager;

public class CommonProxy {
    public void registerBlock(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void register(FMLPreInitializationEvent event) {
        this.registerConfig(event);
        this.registerBlocks();
        this.registerItems();
        this.registerModels();
        this.registerTileEntities();
        this.registerRecipeTypes();
        this.registerNetwork();
    }

    protected void registerConfig(FMLPreInitializationEvent event) {
        PackagedAutoConfig.init(event.getSuggestedConfigurationFile());
    }

    protected void registerBlocks() {
        this.registerBlock(BlockPackager.INSTANCE);
        this.registerBlock(BlockEncoder.INSTANCE);
        this.registerBlock(BlockUnpackager.INSTANCE);
        this.registerBlock(BlockPackagerExtension.INSTANCE);
        if (TileCrafter.enabled) {
            this.registerBlock(BlockCrafter.INSTANCE);
        }
    }

    protected void registerItems() {
        this.registerItem(BlockPackager.ITEM_INSTANCE);
        this.registerItem(BlockEncoder.ITEM_INSTANCE);
        this.registerItem(BlockUnpackager.ITEM_INSTANCE);
        this.registerItem(BlockPackagerExtension.ITEM_INSTANCE);
        if (TileCrafter.enabled) {
            this.registerItem(BlockCrafter.ITEM_INSTANCE);
        }
        this.registerItem(ItemRecipeHolder.INSTANCE);
        this.registerItem(ItemPackage.INSTANCE);
        this.registerItem(ItemMisc.PACKAGE_COMPONENT);
        this.registerItem(ItemMisc.ME_PACKAGE_COMPONENT);
    }

    protected void registerModels() {
    }

    protected void registerTileEntities() {
        GameRegistry.registerTileEntity(TilePackager.class, (ResourceLocation)new ResourceLocation("packagedauto:packager"));
        GameRegistry.registerTileEntity(TileEncoder.class, (ResourceLocation)new ResourceLocation("packagedauto:encoder"));
        GameRegistry.registerTileEntity(TileUnpackager.class, (ResourceLocation)new ResourceLocation("packagedauto:unpackager"));
        GameRegistry.registerTileEntity(TilePackagerExtension.class, (ResourceLocation)new ResourceLocation("packagedauto:packager_extension"));
        if (TileCrafter.enabled) {
            GameRegistry.registerTileEntity(TileCrafter.class, (ResourceLocation)new ResourceLocation("packagedauto:crafter"));
        }
    }

    protected void registerRecipeTypes() {
        RecipeTypeRegistry.registerRecipeType(RecipeTypeProcessing.INSTANCE);
        RecipeTypeRegistry.registerRecipeType(RecipeTypeProcessingOrdered.INSTANCE);
        if (TileCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType(RecipeTypeCrafting.INSTANCE);
        }
    }

    protected void registerNetwork() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)PackagedAuto.instance, (IGuiHandler)GuiHandler.INSTANCE);
        PacketHandler.registerPackets();
    }
}

