/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import net.minecraftforge.common.config.Configuration;

public class TrashContainerSettings {
    public static final TrashContainerSettings NONE = new TrashContainerSettings(){

        @Override
        public void setEnabled(boolean isEnabled) {
        }
    };
    public static final String ENABLED_DESC = "True if this screen should have a trash slot.";
    public static final String SLOT_X_DESC = "The x coordinate of the slot relative to the anchor.";
    public static final String SLOT_Y_DESC = "The y coordinate of the slot relative to the anchor.";
    public static final String ANCHOR_X_DESC = "The x coordinate of the anchor point for the slot position.";
    public static final float ANCHOR_X_DEFAULT = 0.5f;
    public static final String ANCHOR_Y_DESC = "The y coordinate of the anchor point for the slot position.";
    public static final float ANCHOR_Y_DEFAULT = 0.5f;
    private final String category;
    private final int defaultSlotX;
    private final int defaultSlotY;
    private final boolean isEnabledDefault;
    public int slotX;
    public int slotY;
    public float anchorX;
    public float anchorY;
    private boolean isEnabled;

    private TrashContainerSettings() {
        this.category = "null";
        this.defaultSlotX = 0;
        this.defaultSlotY = 0;
        this.isEnabledDefault = false;
    }

    public TrashContainerSettings(Configuration config, String category, int defaultSlotX, int defaultSlotY, boolean isEnabledDefault) {
        this.category = category;
        this.defaultSlotX = defaultSlotX;
        this.defaultSlotY = defaultSlotY;
        this.isEnabledDefault = isEnabledDefault;
        this.slotX = config.getInt("Slot X", category, defaultSlotX, -600, 600, SLOT_X_DESC);
        this.slotY = config.getInt("Slot Y", category, defaultSlotY, -600, 600, SLOT_Y_DESC);
        this.anchorX = config.getFloat("Anchor X", category, 0.5f, 0.0f, 1.0f, ANCHOR_X_DESC);
        this.anchorY = config.getFloat("Anchor Y", category, 0.5f, 0.0f, 1.0f, ANCHOR_Y_DESC);
        this.isEnabled = config.getBoolean("Enabled", category, isEnabledDefault, ENABLED_DESC);
    }

    public void save(Configuration config) {
        config.get(this.category, "Slot X", this.defaultSlotX, SLOT_X_DESC, -600, 600).set(this.slotX);
        config.get(this.category, "Slot Y", this.defaultSlotY, SLOT_Y_DESC, -600, 600).set(this.slotY);
        config.get(this.category, "Anchor X", 0.5, ANCHOR_X_DESC).set((double)this.anchorX);
        config.get(this.category, "Anchor Y", 0.5, ANCHOR_Y_DESC).set((double)this.anchorY);
        config.get(this.category, "Enabled", this.isEnabledDefault, ENABLED_DESC).set(this.isEnabled);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

