/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.implementations.GuiCellWorkbench;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.interfaces.IJEIGhostIngredients;
import appeng.container.slot.IJEITargetSlot;
import appeng.container.slot.SlotFake;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.fluids.client.gui.widgets.GuiFluidSlot;
import appeng.fluids.util.AEFluidStack;
import appeng.helpers.InventoryAction;
import appeng.parts.automation.PartExportBus;
import appeng.parts.automation.PartImportBus;
import appeng.util.item.AEItemStack;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.lwjgl.input.Mouse;

public class GuiUpgradeable
extends AEBaseGui
implements IJEIGhostIngredients {
    private final Map<IGhostIngredientHandler.Target<?>, Object> mapTargetSlot = new HashMap();
    protected final ContainerUpgradeable cvb;
    protected final IUpgradeableHost bc;
    protected GuiImgButton redstoneMode;
    protected GuiImgButton fuzzyMode;
    protected GuiImgButton craftMode;
    protected GuiImgButton schedulingMode;

    public GuiUpgradeable(InventoryPlayer inventoryPlayer, IUpgradeableHost te) {
        this(new ContainerUpgradeable(inventoryPlayer, te));
    }

    public GuiUpgradeable(ContainerUpgradeable te) {
        super(te);
        this.cvb = te;
        this.bc = (IUpgradeableHost)te.getTarget();
        this.field_146999_f = this.hasToolbox() ? 246 : 211;
        this.field_147000_g = 184;
    }

    protected boolean hasToolbox() {
        return ((ContainerUpgradeable)this.field_147002_h).hasToolbox();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButtons();
    }

    @Override
    public List<Rectangle> getJEIExclusionArea() {
        ArrayList<Rectangle> exclusionArea = new ArrayList<Rectangle>();
        int yOffset = this.field_147009_r + 8;
        int visibleButtons = (int)this.field_146292_n.stream().filter(v -> v.field_146124_l && v.field_146128_h < this.field_147003_i).count();
        Rectangle sortDir = new Rectangle(this.field_147003_i - 18, yOffset, 18, visibleButtons * 18 + visibleButtons - 2);
        exclusionArea.add(sortDir);
        return exclusionArea;
    }

    protected void addButtons() {
        this.redstoneMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.schedulingMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.field_146292_n.add(this.craftMode);
        this.field_146292_n.add(this.redstoneMode);
        this.field_146292_n.add(this.fuzzyMode);
        this.field_146292_n.add(this.schedulingMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(this.getName().getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.getRedStoneMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.getCraftingMode());
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(this.cvb.getSchedulingMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 14 + this.cvb.availableUpgrades() * 18);
        }
        if (this.hasToolbox()) {
            this.func_73729_b(offsetX + 178, offsetY + this.field_147000_g - 90, 178, this.field_147000_g - 90, 68, 68);
        }
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CAPACITY) > 0 && this.bc instanceof PartExportBus);
        }
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected GuiText getName() {
        return this.bc instanceof PartImportBus ? GuiText.ImportBus : GuiText.ExportBus;
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.redstoneMode) {
            NetworkHandler.instance().sendToServer(new PacketConfigButton(this.redstoneMode.getSetting(), backwards));
        }
        if (btn == this.craftMode) {
            NetworkHandler.instance().sendToServer(new PacketConfigButton(this.craftMode.getSetting(), backwards));
        }
        if (btn == this.fuzzyMode) {
            NetworkHandler.instance().sendToServer(new PacketConfigButton(this.fuzzyMode.getSetting(), backwards));
        }
        if (btn == this.schedulingMode) {
            NetworkHandler.instance().sendToServer(new PacketConfigButton(this.schedulingMode.getSetting(), backwards));
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        this.mapTargetSlot.clear();
        FluidStack fluidStack = null;
        ItemStack itemStack = ItemStack.field_190927_a;
        if (ingredient instanceof ItemStack) {
            itemStack = (ItemStack)ingredient;
            fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        } else if (ingredient instanceof FluidStack) {
            fluidStack = (FluidStack)ingredient;
        }
        if (!(ingredient instanceof ItemStack) && !(ingredient instanceof FluidStack)) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        ArrayList<IJEITargetSlot> slots = new ArrayList<IJEITargetSlot>();
        if (this.field_147002_h.field_75151_b.size() > 0) {
            for (Slot slot : this.field_147002_h.field_75151_b) {
                if (!(slot instanceof SlotFake) || itemStack.func_190926_b() && (!(this instanceof GuiCellWorkbench) || fluidStack == null)) continue;
                slots.add((IJEITargetSlot)slot);
            }
        }
        if (this.getGuiSlots().size() > 0) {
            for (GuiCustomSlot guiCustomSlot : this.getGuiSlots()) {
                if (!(guiCustomSlot instanceof GuiFluidSlot) || fluidStack == null) continue;
                slots.add((IJEITargetSlot)((Object)guiCustomSlot));
            }
        }
        for (final Object object : slots) {
            final ItemStack finalItemStack = itemStack;
            final FluidStack finalFluidStack = fluidStack;
            IGhostIngredientHandler.Target<Object> targetItem = new IGhostIngredientHandler.Target<Object>(){

                public Rectangle getArea() {
                    if (object instanceof SlotFake && ((SlotFake)object).isSlotEnabled()) {
                        return new Rectangle(GuiUpgradeable.this.getGuiLeft() + ((SlotFake)object).field_75223_e, GuiUpgradeable.this.getGuiTop() + ((SlotFake)object).field_75221_f, 16, 16);
                    }
                    if (object instanceof GuiFluidSlot && ((GuiFluidSlot)object).isSlotEnabled()) {
                        return new Rectangle(GuiUpgradeable.this.getGuiLeft() + ((GuiFluidSlot)object).xPos(), GuiUpgradeable.this.getGuiTop() + ((GuiFluidSlot)object).yPos(), 16, 16);
                    }
                    return new Rectangle();
                }

                public void accept(Object ingredient) {
                    PacketInventoryAction p = null;
                    try {
                        if (object instanceof SlotFake && ((SlotFake)object).isSlotEnabled()) {
                            if (finalItemStack.func_190926_b() && finalFluidStack != null) {
                                p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (IJEITargetSlot)object, (IAEItemStack)AEItemStack.fromItemStack(FluidUtil.getFilledBucket((FluidStack)finalFluidStack)));
                            } else if (!finalItemStack.func_190926_b()) {
                                p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (IJEITargetSlot)object, (IAEItemStack)AEItemStack.fromItemStack(finalItemStack));
                            }
                        } else {
                            if (finalFluidStack == null) {
                                return;
                            }
                            p = new PacketInventoryAction(InventoryAction.PLACE_JEI_GHOST_ITEM, (IJEITargetSlot)object, (IAEItemStack)AEItemStack.fromItemStack(AEFluidStack.fromFluidStack(finalFluidStack).asItemStackRepresentation()));
                        }
                        NetworkHandler.instance().sendToServer(p);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            targets.add(targetItem);
            this.mapTargetSlot.putIfAbsent(targetItem, object);
        }
        return targets;
    }

    @Override
    public Map<IGhostIngredientHandler.Target<?>, Object> getFakeSlotTargetMap() {
        return this.mapTargetSlot;
    }
}

