/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftingJob;
import appeng.crafting.CraftingLink;
import appeng.crafting.CraftingLinkNexus;
import appeng.crafting.CraftingWatcher;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.GenericInterestManager;
import appeng.tile.crafting.TileCraftingStorageTile;
import appeng.tile.crafting.TileCraftingTile;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.minecraft.world.World;

public class CraftingGridCache
implements ICraftingGrid,
ICraftingProviderHelper,
ICellProvider,
IMEInventoryHandler<IAEItemStack> {
    private static final ExecutorService CRAFTING_POOL;
    private static final Comparator<ICraftingPatternDetails> COMPARATOR;
    private final Set<CraftingCPUCluster> craftingCPUClusters = new HashSet<CraftingCPUCluster>();
    private final Set<ICraftingProvider> craftingProviders = new HashSet<ICraftingProvider>();
    private final Map<IGridNode, ICraftingWatcher> craftingWatchers = new HashMap<IGridNode, ICraftingWatcher>();
    private final IGrid grid;
    private final Object2ObjectMap<ICraftingPatternDetails, List<ICraftingMedium>> craftingMethods = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<IAEItemStack, ImmutableList<ICraftingPatternDetails>> craftableItems = new Object2ObjectOpenHashMap();
    private final Set<IAEItemStack> emitableItems = new HashSet<IAEItemStack>();
    private final Map<String, CraftingLinkNexus> craftingLinks = new HashMap<String, CraftingLinkNexus>();
    private final Multimap<IAEStack, CraftingWatcher> interests = HashMultimap.create();
    private final GenericInterestManager<CraftingWatcher> interestManager = new GenericInterestManager<CraftingWatcher>(this.interests);
    private IStorageGrid storageGrid;
    private IEnergyGrid energyGrid;
    int i;
    private boolean updateList = false;
    private boolean updatePatterns = false;

    public CraftingGridCache(IGrid grid) {
        this.grid = grid;
    }

    @MENetworkEventSubscribe
    public void afterCacheConstruction(MENetworkPostCacheConstruction cacheConstruction) {
        this.storageGrid = (IStorageGrid)this.grid.getCache(IStorageGrid.class);
        this.energyGrid = (IEnergyGrid)this.grid.getCache(IEnergyGrid.class);
        this.storageGrid.registerCellProvider(this);
    }

    @Override
    public void onUpdateTick() {
        if (this.updateList) {
            this.updateList = false;
            this.updateCPUClusters();
        }
        if (this.updatePatterns) {
            this.recalculateCraftingPatterns();
            this.updatePatterns = false;
        }
        Iterator<CraftingLinkNexus> craftingLinkIterator = this.craftingLinks.values().iterator();
        while (craftingLinkIterator.hasNext()) {
            if (!craftingLinkIterator.next().isDead(this.grid, this)) continue;
            craftingLinkIterator.remove();
        }
        for (CraftingCPUCluster cpu : this.craftingCPUClusters) {
            cpu.updateCraftingLogic(this.grid, this.energyGrid, this);
        }
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        ICraftingWatcher craftingWatcher;
        if (machine instanceof ICraftingWatcherHost && (craftingWatcher = this.craftingWatchers.get(gridNode)) != null) {
            craftingWatcher.reset();
            this.craftingWatchers.remove(gridNode);
        }
        if (machine instanceof ICraftingRequester) {
            for (CraftingLinkNexus link : this.craftingLinks.values()) {
                if (!link.isMachine(machine)) continue;
                link.removeNode();
            }
        }
        if (machine instanceof TileCraftingTile) {
            this.updateList = true;
        }
        if (machine instanceof ICraftingProvider) {
            this.craftingProviders.remove(machine);
            this.updatePatterns = true;
        }
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        if (machine instanceof ICraftingWatcherHost) {
            ICraftingWatcherHost watcherHost = (ICraftingWatcherHost)((Object)machine);
            CraftingWatcher watcher = new CraftingWatcher(this, watcherHost);
            this.craftingWatchers.put(gridNode, watcher);
            watcherHost.updateWatcher(watcher);
        }
        if (machine instanceof ICraftingRequester) {
            for (ICraftingLink link : ((ICraftingRequester)((Object)machine)).getRequestedJobs()) {
                if (!(link instanceof CraftingLink)) continue;
                this.addLink((CraftingLink)link);
            }
        }
        if (machine instanceof TileCraftingTile) {
            this.updateList = true;
        }
        if (machine instanceof ICraftingProvider) {
            this.craftingProviders.add((ICraftingProvider)((Object)machine));
            this.updatePatterns = true;
        }
    }

    @Override
    public void onSplit(IGridStorage destinationStorage) {
    }

    @Override
    public void onJoin(IGridStorage sourceStorage) {
    }

    @Override
    public void populateGridStorage(IGridStorage destinationStorage) {
    }

    private void updatePatterns() {
        this.updatePatterns = true;
    }

    private void recalculateCraftingPatterns() {
        IAEItemStack changedStack;
        Object2ObjectOpenHashMap oldItems = new Object2ObjectOpenHashMap(this.craftableItems);
        HashSet<IAEItemStack> oldEmitableItems = new HashSet<IAEItemStack>(this.emitableItems);
        this.craftingMethods.clear();
        this.craftableItems.clear();
        this.emitableItems.clear();
        for (ICraftingProvider provider : this.craftingProviders) {
            provider.provideCrafting(this);
        }
        Object2ObjectOpenHashMap tmpCraft = new Object2ObjectOpenHashMap();
        for (ICraftingPatternDetails details : this.craftingMethods.keySet()) {
            for (Object out : details.getOutputs()) {
                out = out.copy();
                out.reset();
                out.setCraftable(true);
                ObjectSet methods = (ObjectSet)tmpCraft.get(out);
                if (methods == null) {
                    methods = new ObjectRBTreeSet(COMPARATOR);
                    tmpCraft.put(out, (Object)methods);
                }
                methods.add((Object)details);
            }
        }
        for (Map.Entry e : tmpCraft.entrySet()) {
            this.craftableItems.put(e.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)e.getValue())));
        }
        ArrayList<IAEItemStack> craftablesChanged = new ArrayList<IAEItemStack>();
        ObjectSet i = oldItems.entrySet();
        for (Map.Entry ais : i) {
            if (this.craftableItems.containsKey(ais.getKey())) continue;
            IAEItemStack changedStack2 = ((IAEItemStack)ais.getKey()).copy();
            changedStack2.reset();
            changedStack2.setCraftable(false);
            craftablesChanged.add(changedStack2);
        }
        ObjectSet j = this.craftableItems.entrySet();
        for (Map.Entry ais : j) {
            if (oldItems.containsKey((Object)ais)) continue;
            changedStack = ((IAEItemStack)ais.getKey()).copy();
            changedStack.reset();
            changedStack.setCraftable(true);
            craftablesChanged.add(changedStack);
        }
        for (IAEItemStack st : oldEmitableItems) {
            if (this.emitableItems.contains(st)) continue;
            changedStack = st.copy();
            changedStack.reset();
            changedStack.setCraftable(false);
            craftablesChanged.add(changedStack);
        }
        for (IAEItemStack st : this.emitableItems) {
            if (oldEmitableItems.contains(st)) continue;
            changedStack = st.copy();
            changedStack.reset();
            changedStack.setCraftable(true);
            craftablesChanged.add(changedStack);
        }
        this.storageGrid.postCraftablesChanges(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class), craftablesChanged, new BaseActionSource());
    }

    private void updateCPUClusters() {
        this.craftingCPUClusters.clear();
        for (IGridNode cst : this.grid.getMachines(TileCraftingStorageTile.class)) {
            TileCraftingStorageTile tile = (TileCraftingStorageTile)cst.getMachine();
            CraftingCPUCluster cluster = (CraftingCPUCluster)tile.getCluster();
            if (cluster == null) continue;
            this.craftingCPUClusters.add(cluster);
            if (cluster.getLastCraftingLink() == null) continue;
            this.addLink((CraftingLink)cluster.getLastCraftingLink());
        }
    }

    public void addLink(CraftingLink link) {
        if (link.isStandalone()) {
            return;
        }
        CraftingLinkNexus nexus = this.craftingLinks.get(link.getCraftingID());
        if (nexus == null) {
            nexus = new CraftingLinkNexus(link.getCraftingID());
            this.craftingLinks.put(link.getCraftingID(), nexus);
        }
        link.setNexus(nexus);
    }

    @MENetworkEventSubscribe
    public void updateCPUClusters(MENetworkCraftingCpuChange c) {
        this.updateList = true;
    }

    @MENetworkEventSubscribe
    public void updateCPUClusters(MENetworkCraftingPatternChange c) {
        this.updatePatterns();
    }

    @Override
    public void addCraftingOption(ICraftingMedium medium, ICraftingPatternDetails api) {
        ArrayList<ICraftingMedium> details = (ArrayList<ICraftingMedium>)this.craftingMethods.get((Object)api);
        if (details == null) {
            details = new ArrayList<ICraftingMedium>();
            details.add(medium);
            this.craftingMethods.put((Object)api, details);
        } else {
            details.add(medium);
        }
    }

    @Override
    public void setEmitable(IAEItemStack someItem) {
        this.emitableItems.add(someItem.copy());
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>(1);
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            list.add(this);
        }
        return list;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return true;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        for (CraftingCPUCluster cpu : this.craftingCPUClusters) {
            if (!cpu.canAccept(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return i == 1;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, IActionSource src) {
        for (CraftingCPUCluster cpu : this.craftingCPUClusters) {
            input = cpu.injectItems(input, type, src);
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (IAEItemStack stack : this.craftableItems.keySet()) {
            out.addCrafting(stack);
        }
        for (IAEItemStack st : this.emitableItems) {
            out.addCrafting(st);
        }
        return out;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public ImmutableCollection<ICraftingPatternDetails> getCraftingFor(IAEItemStack whatToCraft, ICraftingPatternDetails details, int slotIndex, World world) {
        ImmutableList res = (ImmutableList)this.craftableItems.get((Object)whatToCraft);
        if (res == null) {
            return ImmutableSet.of();
        }
        return res;
    }

    @Override
    public Future<ICraftingJob> beginCraftingJob(World world, IGrid grid, IActionSource actionSrc, IAEItemStack slotItem, ICraftingCallback cb) {
        if (world == null || grid == null || actionSrc == null || slotItem == null) {
            throw new IllegalArgumentException("Invalid Crafting Job Request");
        }
        CraftingJob job = new CraftingJob(world, grid, actionSrc, slotItem, cb);
        return CRAFTING_POOL.submit(job, job);
    }

    @Override
    public ICraftingLink submitJob(ICraftingJob job, ICraftingRequester requestingMachine, ICraftingCPU target, boolean prioritizePower, IActionSource src) {
        if (job.isSimulation()) {
            return null;
        }
        CraftingCPUCluster cpuCluster = null;
        if (target instanceof CraftingCPUCluster) {
            cpuCluster = (CraftingCPUCluster)target;
        }
        if (target == null) {
            ArrayList<CraftingCPUCluster> validCpusClusters = new ArrayList<CraftingCPUCluster>();
            for (CraftingCPUCluster cpu : this.craftingCPUClusters) {
                if (!cpu.isActive() || cpu.isBusy() || cpu.getAvailableStorage() < job.getByteTotal()) continue;
                validCpusClusters.add(cpu);
            }
            Collections.sort(validCpusClusters, (firstCluster, nextCluster) -> {
                if (prioritizePower) {
                    int comparison1 = Long.compare(nextCluster.getCoProcessors(), firstCluster.getCoProcessors());
                    if (comparison1 != 0) {
                        return comparison1;
                    }
                    return Long.compare(nextCluster.getAvailableStorage(), firstCluster.getAvailableStorage());
                }
                int comparison2 = Long.compare(firstCluster.getCoProcessors(), nextCluster.getCoProcessors());
                if (comparison2 != 0) {
                    return comparison2;
                }
                return Long.compare(firstCluster.getAvailableStorage(), nextCluster.getAvailableStorage());
            });
            if (!validCpusClusters.isEmpty()) {
                cpuCluster = (CraftingCPUCluster)validCpusClusters.get(0);
            }
        }
        if (cpuCluster != null) {
            return cpuCluster.submitJob(this.grid, job, src, requestingMachine);
        }
        return null;
    }

    @Override
    public ImmutableSet<ICraftingCPU> getCpus() {
        return ImmutableSet.copyOf((Iterator)new ActiveCpuIterator(this.craftingCPUClusters));
    }

    @Override
    public boolean canEmitFor(IAEItemStack someItem) {
        return this.emitableItems.contains(someItem);
    }

    @Override
    public boolean isRequesting(IAEItemStack what) {
        return this.requesting(what) > 0L;
    }

    @Override
    public long requesting(IAEItemStack what) {
        long requested = 0L;
        for (CraftingCPUCluster cluster : this.craftingCPUClusters) {
            IAEItemStack stack = cluster.making(what);
            requested += stack != null ? stack.getStackSize() : 0L;
        }
        return requested;
    }

    public List<ICraftingMedium> getMediums(ICraftingPatternDetails key) {
        List mediums = (List)this.craftingMethods.get((Object)key);
        if (mediums == null) {
            mediums = ImmutableList.of();
        }
        return mediums;
    }

    public boolean hasCpu(ICraftingCPU cpu) {
        if (cpu instanceof CraftingCPUCluster) {
            return this.craftingCPUClusters.contains((CraftingCPUCluster)cpu);
        }
        return false;
    }

    public GenericInterestManager<CraftingWatcher> getInterestManager() {
        return this.interestManager;
    }

    static {
        COMPARATOR = (firstDetail, nextDetail) -> nextDetail.getPriority() - firstDetail.getPriority();
        ThreadFactory factory = ar -> new Thread(ar, "AE Crafting Calculator");
        CRAFTING_POOL = Executors.newCachedThreadPool(factory);
    }

    private static class ActiveCpuIterator
    implements Iterator<ICraftingCPU> {
        private final Iterator<CraftingCPUCluster> iterator;
        private CraftingCPUCluster cpuCluster;

        public ActiveCpuIterator(Collection<CraftingCPUCluster> o) {
            this.iterator = o.iterator();
            this.cpuCluster = null;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.cpuCluster != null;
        }

        private void findNext() {
            while (this.iterator.hasNext() && this.cpuCluster == null) {
                this.cpuCluster = this.iterator.next();
                if (this.cpuCluster.isActive() && !this.cpuCluster.isDestroyed()) continue;
                this.cpuCluster = null;
            }
        }

        @Override
        public ICraftingCPU next() {
            CraftingCPUCluster o = this.cpuCluster;
            this.cpuCluster = null;
            return o;
        }

        @Override
        public void remove() {
        }
    }
}

