/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class InputHelper {
    public static boolean isABlock(IItemStack block) {
        return InputHelper.isABlock(InputHelper.toStack(block));
    }

    public static IItemStack[] toStacks(IIngredient[] iIngredient) {
        ArrayList stacks = new ArrayList();
        Arrays.stream(iIngredient).map(IIngredient::getItems).forEach(stacks::addAll);
        return stacks.toArray(new IItemStack[0]);
    }

    public static boolean isABlock(ItemStack block) {
        return !block.func_190926_b() && block.func_77973_b() instanceof ItemBlock;
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            LogHelper.error((Object)("Not a valid item stack: " + iStack));
        }
        return (ItemStack)internal;
    }

    public static IIngredient toIngredient(ItemStack stack) {
        return InputHelper.toIItemStack(stack);
    }

    public static IIngredient toIngredient(FluidStack stack) {
        return stack == null ? null : new MCLiquidStack(stack);
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        return stack == null ? null : new MCItemStack(stack);
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        return iStack == null ? null : (ItemStack[])Arrays.stream(iStack).map(InputHelper::toStack).toArray(ItemStack[]::new);
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return InputHelper.toString((IOreDictEntry)iStack);
        }
        return iStack instanceof IItemStack ? InputHelper.toStack((IItemStack)iStack) : null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        return ingredient == null ? null : Arrays.stream(ingredient).map(iIngredient -> {
            if (iIngredient != null) {
                return InputHelper.toObject(iIngredient);
            }
            return "";
        }).toArray();
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }
}

