/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.base.special;

import com.sofodev.armorplus.api.properties.iface.IDurable;
import com.sofodev.armorplus.api.properties.iface.IRemovable;
import com.sofodev.armorplus.api.properties.iface.IRepairable;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.registry.ModBlocks;
import com.sofodev.armorplus.common.registry.ModItems;
import com.sofodev.armorplus.common.registry.constants.APItems;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public enum Bows implements IRepairable,
IRemovable,
IDurable
{
    COAL(ItemStackUtils.getItemStack((Object)Blocks.field_150402_ci), ModConfig.RegistryConfig.coal, APItems.coalBow),
    LAPIS(ItemStackUtils.getItemStack((Object)Blocks.field_150368_y), ModConfig.RegistryConfig.lapis, APItems.lapisBow),
    REDSTONE(ItemStackUtils.getItemStack((Object)Blocks.field_150451_bX), ModConfig.RegistryConfig.redstone, APItems.redstoneBow),
    EMERALD(ItemStackUtils.getItemStack((Object)Blocks.field_150475_bE), ModConfig.RegistryConfig.emerald, APItems.emeraldBow),
    OBSIDIAN(ItemStackUtils.getItemStack((Object)ModBlocks.blockCompressedObsidian), ModConfig.RegistryConfig.obsidian, APItems.obsidianBow),
    INFUSED_LAVA(ItemStackUtils.getItemStack((Object)ModItems.itemLavaCrystal, (int)1), ModConfig.RegistryConfig.lava, APItems.lavaBow),
    GUARDIAN(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)1), ModConfig.RegistryConfig.guardian, APItems.guardianBow),
    SUPER_STAR(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)2), ModConfig.RegistryConfig.super_star, APItems.superStarBow),
    ENDER_DRAGON(ItemStackUtils.getItemStack((Object)ModItems.materials, (int)3), ModConfig.RegistryConfig.ender_dragon, APItems.enderDragonBow);

    private final BowStats bowStats;
    private final ItemStack repairStack;
    private final TextFormatting textFormatting;
    private final Item bowItem;

    private Bows(ItemStack repairStackIn, ModConfig.RegistryConfig.OriginMaterial material, Item bowItemIn) {
        this.bowStats = new BowStats(material);
        if (repairStackIn == null) {
            repairStackIn = ItemStack.field_190927_a;
        }
        this.repairStack = repairStackIn;
        this.textFormatting = TextFormatting.func_96300_b((String)material.weapons.itemNameColor);
        this.bowItem = bowItemIn;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public double getDamage() {
        return this.bowStats.getBonusDamage();
    }

    @Override
    public int getDurability(boolean unbreakable) {
        return this.bowStats.getDurability();
    }

    public Item getBowItem() {
        return this.bowItem;
    }

    @Override
    public ItemStack getRepairStack() {
        return this.repairStack;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    private static class BowStats {
        private final int durabilityIn;
        private final double bonusDamage;

        BowStats(ModConfig.RegistryConfig.OriginMaterial material) {
            this(material.weapons.bow.durability, material.weapons.bow.arrowBonusDamage);
        }

        private BowStats(int durability, double bonusDamage) {
            this.durabilityIn = durability;
            this.bonusDamage = bonusDamage;
        }

        double getBonusDamage() {
            return this.bonusDamage;
        }

        int getDurability() {
            return this.durabilityIn;
        }
    }
}

