/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.api;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerOre;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import gregtech.api.GregTechAPI;
import gregtech.api.recipes.crafttweaker.MetaItemBracketHandler;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.Utils")
@ZenRegister
public class RecipeUtils {
    @ZenMethod(value="fluid")
    public static ILiquidStack getFluid(String name) {
        ILiquidStack fluid = BracketHandlerLiquid.getLiquid((String)name);
        if (fluid == null) {
            CraftTweakerAPI.logError((String)("Can't find fluid for " + name));
            return null;
        }
        return fluid;
    }

    @ZenMethod(value="fluid")
    public static ILiquidStack getFluid(Material material) {
        return new MCLiquidStack(material.getFluid(1));
    }

    @ZenMethod(value="item")
    public static IItemStack getItem(String name, @Optional int meta) {
        IItemStack item;
        if (meta < 0) {
            meta = Short.MAX_VALUE;
        }
        if ((item = BracketHandlerItem.getItem((String)name, (int)meta)) == null) {
            return MCItemStack.EMPTY;
        }
        return item;
    }

    @ZenMethod(value="metaitem")
    public static IItemStack getMetaItem(String name) {
        IItemStack item = MetaItemBracketHandler.getMetaItem((String)name);
        if (item == null) {
            return MCItemStack.EMPTY;
        }
        return item;
    }

    @Nullable
    @ZenMethod(value="material")
    public static Material getMaterial(String name) {
        return (Material)GregTechAPI.MATERIAL_REGISTRY.func_82594_a((Object)name);
    }

    @ZenMethod(value="ore")
    public IIngredient getOreEntry(String name) {
        return BracketHandlerOre.getOre((String)name);
    }

    @ZenMethod(value="item")
    public static IItemStack getItem(OrePrefix orePrefix, Material material) {
        return new MCItemStack(OreDictUnifier.get((OrePrefix)orePrefix, (Material)material));
    }

    @ZenMethod(value="item")
    public static IItemStack getItem(String orePrefix, Material material) {
        OrePrefix orePrefix1 = OrePrefix.getPrefix((String)orePrefix);
        if (orePrefix1 == null) {
            CraftTweakerAPI.logError((String)("Can't find ore prefix " + orePrefix));
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(OreDictUnifier.get((OrePrefix)orePrefix1, (Material)material));
    }

    @ZenMethod(value="item")
    public static IItemStack getItem(OrePrefix orePrefix, String material) {
        Material material1 = GregTechAPI.MaterialRegistry.get((String)material);
        if (material1 == null) {
            CraftTweakerAPI.logError((String)("Can't find material " + orePrefix));
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(OreDictUnifier.get((OrePrefix)orePrefix, (Material)material1));
    }

    @ZenMethod(value="item")
    public static IItemStack getItem(String orePrefix, String material) {
        OrePrefix orePrefix1 = OrePrefix.getPrefix((String)orePrefix);
        if (orePrefix1 == null) {
            CraftTweakerAPI.logError((String)("Can't find ore prefix " + orePrefix));
            return MCItemStack.EMPTY;
        }
        Material material1 = GregTechAPI.MaterialRegistry.get((String)material);
        if (material1 == null) {
            CraftTweakerAPI.logError((String)("Can't find material " + orePrefix));
            return MCItemStack.EMPTY;
        }
        return new MCItemStack(OreDictUnifier.get((OrePrefix)orePrefix1, (Material)material1));
    }

    @ZenMethod(value="ore")
    public static IIngredient getOreEntry(OrePrefix orePrefix, Material material) {
        UnificationEntry entry = new UnificationEntry(orePrefix, material);
        return new IngredientStack((IIngredient)CraftTweakerMC.getOreDict((String)entry.toString()), 1);
    }

    @ZenMethod(value="ore")
    public static IIngredient getOreEntry(String orePrefix, Material material) {
        OrePrefix orePrefix1 = OrePrefix.getPrefix((String)orePrefix);
        if (orePrefix1 == null) {
            CraftTweakerAPI.logError((String)("Can't find ore prefix " + orePrefix));
            return MCItemStack.EMPTY;
        }
        UnificationEntry entry = new UnificationEntry(orePrefix1, material);
        return new IngredientStack((IIngredient)CraftTweakerMC.getOreDict((String)entry.toString()), 1);
    }

    @ZenMethod(value="ore")
    public static IIngredient getOreEntry(OrePrefix orePrefix, String material) {
        Material material1 = GregTechAPI.MaterialRegistry.get((String)material);
        if (material1 == null) {
            CraftTweakerAPI.logError((String)("Can't find material " + orePrefix));
            return MCItemStack.EMPTY;
        }
        UnificationEntry entry = new UnificationEntry(orePrefix, material1);
        return new IngredientStack((IIngredient)CraftTweakerMC.getOreDict((String)entry.toString()), 1);
    }

    @ZenMethod(value="ore")
    public static IIngredient getOreEntry(String orePrefix, String material) {
        OrePrefix orePrefix1 = OrePrefix.getPrefix((String)orePrefix);
        if (orePrefix1 == null) {
            CraftTweakerAPI.logError((String)("Can't find ore prefix " + orePrefix));
            return MCItemStack.EMPTY;
        }
        Material material1 = GregTechAPI.MaterialRegistry.get((String)material);
        if (material1 == null) {
            CraftTweakerAPI.logError((String)("Can't find material " + orePrefix));
            return MCItemStack.EMPTY;
        }
        UnificationEntry entry = new UnificationEntry(orePrefix1, material1);
        return new IngredientStack((IIngredient)CraftTweakerMC.getOreDict((String)entry.toString()), 1);
    }
}

