/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.common.machines;

import com.zook.devtech.common.machines.SteamMachineData;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFilteredFluidHandler;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import java.util.HashSet;
import java.util.function.DoubleSupplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleSteamMachine
extends SteamMetaTileEntity {
    private final SteamMachineData data;
    private final RecipeMap<?> recipeMap;

    public SimpleSteamMachine(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, SteamMachineData data) {
        super(metaTileEntityId, recipeMap, renderer, data.highPressure);
        this.recipeMap = recipeMap;
        this.data = data;
        if (data.progressBar == null) {
            data.progressBar = GuiTextures.PROGRESS_BAR_ARROW_STEAM.get(data.highPressure);
        }
        if (data.moveType == null) {
            data.moveType = ProgressWidget.MoveType.HORIZONTAL;
        }
        if (data.conversionRate < 0.0) {
            data.conversionRate = 1.0;
        }
        this.initializeInventory();
        this.workableHandler = new RecipeLogicSteam((MetaTileEntity)this, recipeMap, data.highPressure, (IFluidTank)this.steamFluidTank, data.conversionRate);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity metaTileEntityHolder) {
        return new SimpleSteamMachine(this.metaTileEntityId, this.getRecipeMap(), this.renderer, this.data);
    }

    protected boolean isBrickedCasing() {
        return this.data.bricked;
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.recipeMap == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler(this.recipeMap.getMaxInputs(), (MetaTileEntity)this, false);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.recipeMap == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler(this.recipeMap.getMaxOutputs(), (MetaTileEntity)this, true);
    }

    public FluidTankList createImportFluidHandler() {
        if (this.recipeMap == null) {
            this.steamFluidTank = new FluidTank(0);
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FilteredFluidHandler[] fluidImports = new FilteredFluidHandler[this.recipeMap.getMaxFluidInputs() + 1];
        this.steamFluidTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isSteam);
        fluidImports[0] = (FilteredFluidHandler)this.steamFluidTank;
        for (int i = 1; i < fluidImports.length; ++i) {
            NotifiableFilteredFluidHandler filteredFluidHandler = new NotifiableFilteredFluidHandler(this.data.tankSize, (MetaTileEntity)this, false);
            filteredFluidHandler.setFillPredicate(this::canInputFluid);
            fluidImports[i] = filteredFluidHandler;
        }
        return new FluidTankList(false, (IFluidTank[])fluidImports);
    }

    protected FluidTankList createExportFluidHandler() {
        if (this.recipeMap == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FluidTank[] fluidExports = new FluidTank[this.recipeMap.getMaxFluidOutputs()];
        for (int i = 0; i < fluidExports.length; ++i) {
            fluidExports[i] = new NotifiableFluidTank(this.data.tankSize, (MetaTileEntity)this, true);
        }
        return new FluidTankList(false, (IFluidTank[])fluidExports);
    }

    protected boolean canInputFluid(FluidStack inputFluid) {
        if (this.recipeMap.canInputFluidForce(inputFluid.getFluid())) {
            return true;
        }
        HashSet<Recipe> matchingRecipes = null;
        for (IFluidTank fluidTank : this.importFluids) {
            FluidStack fluidInTank = fluidTank.getFluid();
            if (fluidInTank == null) continue;
            if (matchingRecipes == null) {
                matchingRecipes = new HashSet<Recipe>(this.recipeMap.getRecipesForFluid(fluidInTank));
                continue;
            }
            matchingRecipes.removeIf(recipe -> !recipe.hasInputFluid(fluidInTank));
        }
        if (matchingRecipes == null) {
            return !this.recipeMap.getRecipesForFluid(inputFluid).isEmpty();
        }
        return matchingRecipes.stream().anyMatch(recipe -> recipe.hasInputFluid(inputFluid));
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        RecipeMap workableRecipeMap = this.workableHandler.getRecipeMap();
        int yOffset = 0;
        if (workableRecipeMap.getMaxInputs() >= 6 || workableRecipeMap.getMaxFluidInputs() >= 7 || workableRecipeMap.getMaxOutputs() >= 6 || workableRecipeMap.getMaxFluidOutputs() >= 6) {
            yOffset = 9;
        }
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure), (int)176, (int)(166 + yOffset)).label(5, 5, this.getMetaFullName()).widget((Widget)new ImageWidget(79, 42, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(() -> this.workableHandler.isHasNotEnoughEnergy())).widget((Widget)new TankWidget((IFluidTank)this.steamFluidTank, 5, 26 + yOffset, 10, 54).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure)})).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.isHighPressure), yOffset);
        this.buildRecipeUI(builder, () -> ((RecipeLogicSteam)this.workableHandler).getProgressPercent(), this.getImportItems(), this.getExportItems(), this.getImportFluids(), this.getExportFluids(), yOffset);
        return builder;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void buildRecipeUI(ModularUI.Builder builder, DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids, int yOffset) {
        builder.widget((Widget)new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.data.progressBar, this.data.moveType, this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true, yOffset);
    }

    public void buildRecipeUI(ModularUI.Builder builder, DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, int yOffset) {
        builder.widget((Widget)new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, this.data.progressBar, this.data.moveType, this.recipeMap));
        this.addInventorySlotGroup(builder, importItems, this.importFluids, false, yOffset);
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block11: {
            int i;
            boolean wasGroup;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks() - (isOutputs ? 0 : 1);
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = SimpleSteamMachine.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
            int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
            boolean bl = wasGroup = itemHandler.getSlots() + fluidInputsCount == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidInputsCount >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemSlotsToLeft && (slotIndex = i2 * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block11;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget((Widget)new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            if (!isOutputs) {
                ++slotIndex;
            }
            builder.widget((Widget)new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base = isFluid ? GuiTextures.SLOT_STEAM.get(this.isHighPressure) : GuiTextures.SLOT_STEAM.get(this.isHighPressure);
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.data.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.data.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }
}

