/*
 * Decompiled with CFR 0.152.
 */
package com.zook.devtech.common.machines.recipeLogic;

import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import javax.annotation.Nonnull;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;

public class BoilerRecipeLogic
extends RecipeLogicSteam {
    private final boolean isHighPressure;
    private int currentTemperature;
    private boolean hasNoWater;
    private int timeBeforeCoolingDown;
    private final int steamOutput;
    private final int cooldownInterval;
    private final int cooldownRate;
    private final IFluidTank waterFluidTank;
    private final IFluidTank steamFluidTank;

    public BoilerRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean isHighPressure, int steamOutput, int cooldownInterval, int cooldownRate, IFluidTank steamFluidTank, IFluidTank waterFluidTank) {
        super(tileEntity, recipeMap, isHighPressure, steamFluidTank, 1.0);
        this.isHighPressure = isHighPressure;
        this.steamOutput = steamOutput;
        this.cooldownInterval = cooldownInterval;
        this.cooldownRate = cooldownRate;
        this.steamFluidTank = steamFluidTank;
        this.waterFluidTank = waterFluidTank;
    }

    protected int[] runOverclockingLogic(@Nonnull Recipe recipe, boolean negativeEU, int maxOverclocks) {
        return new int[]{recipe.getEUt() * -1, recipe.getDuration()};
    }

    public Enum<ParallelLogicType> getParallelLogicType() {
        return ParallelLogicType.MULTIPLY;
    }

    protected boolean hasEnoughPower(@Nonnull int[] resultOverclock) {
        return true;
    }

    public void applyParallelBonus(@Nonnull RecipeBuilder<?> builder) {
        builder.EUt(builder.getEUt());
    }

    public int getParallelLimit() {
        return 1;
    }

    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        return true;
    }

    public World getWorld() {
        return this.metaTileEntity.getWorld();
    }

    public void setNeedsVenting(boolean needsVenting) {
    }

    public boolean isNeedsVenting() {
        return false;
    }

    public boolean isVentingStuck() {
        return false;
    }

    public void tryDoVenting() {
    }

    public void update() {
        super.update();
        World world = this.metaTileEntity.getWorld();
        if (world != null && !world.field_72995_K && !this.isWorking()) {
            if (this.timeBeforeCoolingDown == 0) {
                this.currentTemperature -= this.cooldownRate;
                this.timeBeforeCoolingDown = this.cooldownInterval;
            } else {
                --this.timeBeforeCoolingDown;
            }
        }
    }

    public int getFuelBurnTimeLeft() {
        return this.maxProgressTime - this.progressTime;
    }

    protected void updateRecipeProgress() {
        if (this.canRecipeProgress) {
            if (this.metaTileEntity.getOffsetTimer() % 10L == 0L) {
                this.generateSteam();
            }
            if (this.metaTileEntity.getOffsetTimer() % 12L == 0L && this.currentTemperature < this.getMaxTemperate()) {
                ++this.currentTemperature;
            }
            this.progressTime += this.isHighPressure ? 2 : 1;
            if (this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
        }
    }

    protected void completeRecipe() {
        super.completeRecipe();
        this.timeBeforeCoolingDown = this.cooldownInterval;
    }

    private void generateSteam() {
        if (this.currentTemperature >= 100) {
            int fillAmount = (int)((double)this.steamOutput * ((double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0)) / 2.0);
            boolean hasDrainedWater = this.waterFluidTank.drain(1, true) != null;
            int filledSteam = 0;
            if (hasDrainedWater) {
                filledSteam = this.steamFluidTank.fill(ModHandler.getSteam((int)fillAmount), true);
            }
            if (this.hasNoWater && hasDrainedWater) {
                this.metaTileEntity.doExplosion(2.0f);
            } else {
                boolean bl = this.hasNoWater = !hasDrainedWater;
            }
            if (filledSteam == 0 && hasDrainedWater) {
                this.getWorld().func_184148_a(null, (double)this.metaTileEntity.getPos().func_177958_n() + 0.5, (double)this.metaTileEntity.getPos().func_177956_o() + 0.5, (double)this.metaTileEntity.getPos().func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.steamFluidTank.drain(4000, true);
            }
        } else {
            this.hasNoWater = false;
        }
    }

    public int getMaxTemperate() {
        return this.isHighPressure ? 1000 : 500;
    }

    public double getTemperaturePercent() {
        return (double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0);
    }

    public double getFuelLeftPercent() {
        return this.maxProgressTime == 0 ? 0.0 : (double)this.getFuelBurnTimeLeft() / ((double)this.maxProgressTime * 1.0);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound data = super.serializeNBT();
        data.func_74768_a("CurrentTemperature", this.currentTemperature);
        data.func_74757_a("HasNoWater", this.hasNoWater);
        return data;
    }

    public void deserializeNBT(NBTTagCompound data) {
        super.deserializeNBT(data);
        this.currentTemperature = data.func_74762_e("CurrentTemperature");
        this.hasNoWater = data.func_74767_n("HasNoWater");
    }
}

