/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;

public class ItemReachUpgrade2
extends Item {
    public ItemReachUpgrade2() {
        this.setRegistryName("effortlessbuilding", "reach_upgrade2");
        this.func_77655_b(this.getRegistryName().toString());
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_184812_l_()) {
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Reach upgrades are not necessary in creative.");
            }
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Still want increased reach? Use the config.");
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        int currentLevel = modifierSettings.getReachUpgrade();
        if (currentLevel == 1) {
            modifierSettings.setReachUpgrade(2);
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Upgraded reach to " + ReachHelper.getMaxReach(player));
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("entity.player.levelup"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        } else if (currentLevel < 1) {
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Use Reach Upgrade 1 first.");
            }
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("item.armor.equip_leather"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        } else if (currentLevel > 1) {
            if (world.field_72995_K) {
                EffortlessBuilding.log(player, "Already used this upgrade! Current reach is " + ReachHelper.getMaxReach(player) + ".");
            }
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("item.armor.equip_leather"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.GRAY + "Consume to increase reach to " + TextFormatting.BLUE + BuildConfig.reach.maxReachLevel2);
        tooltip.add(TextFormatting.GRAY + "Previous upgrades need to be consumed first");
    }

    public String func_77658_a() {
        return super.func_77658_a();
    }
}

