/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.proxy;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifierSettingsGui;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.ModeActionMessage;
import nl.requios.effortlessbuilding.network.ModifierSettingsMessage;
import nl.requios.effortlessbuilding.proxy.IProxy;
import nl.requios.effortlessbuilding.render.RenderHandler;
import nl.requios.effortlessbuilding.render.ShaderHandler;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
implements IProxy {
    public static KeyBinding[] keyBindings;
    public static RayTraceResult previousLookAt;
    public static RayTraceResult currentLookAt;
    private static int placeCooldown;
    private static int breakCooldown;
    public static int ticksInGame;
    private static final HashMap<BuildModes.BuildModeEnum, TextureAtlasSprite> buildModeIcons;
    private static final HashMap<ModeOptions.ActionEnum, TextureAtlasSprite> modeOptionIcons;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ShaderHandler.init();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        keyBindings = new KeyBinding[7];
        ClientProxy.keyBindings[0] = new KeyBinding("key.effortlessbuilding.hud.desc", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, 78, "key.effortlessbuilding.category");
        ClientProxy.keyBindings[1] = new KeyBinding("key.effortlessbuilding.replace.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 74, "key.effortlessbuilding.category");
        ClientProxy.keyBindings[2] = new KeyBinding("key.effortlessbuilding.creative.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "key.effortlessbuilding.category");
        ClientProxy.keyBindings[3] = new KeyBinding("key.effortlessbuilding.mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 56, "key.effortlessbuilding.category"){

            public boolean conflicts(KeyBinding other) {
                if (other.func_151463_i() == this.func_151463_i() && other.func_151464_g().equals("mod.chiselsandbits.other.mode")) {
                    return false;
                }
                return super.conflicts(other);
            }
        };
        ClientProxy.keyBindings[4] = new KeyBinding("key.effortlessbuilding.undo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 44, "key.effortlessbuilding.category");
        ClientProxy.keyBindings[5] = new KeyBinding("key.effortlessbuilding.redo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 21, "key.effortlessbuilding.category");
        ClientProxy.keyBindings[6] = new KeyBinding("key.effortlessbuilding.altplacement.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, 29, "key.effortlessbuilding.category");
        for (int i = 0; i < keyBindings.length; ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : ctx.getServerHandler().field_147369_b;
    }

    @Override
    public IThreadListener getThreadListenerFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : ((EntityPlayerMP)this.getPlayerEntityFromContext(ctx)).func_71121_q();
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Block block : EffortlessBuilding.BLOCKS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
        for (Block block : EffortlessBuilding.ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            event.getWorld().func_72954_a((IWorldEventListener)new RenderHandler());
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation sprite;
        TextureMap map = event.getMap();
        for (BuildModes.BuildModeEnum buildModeEnum : BuildModes.BuildModeEnum.values()) {
            sprite = new ResourceLocation("effortlessbuilding", "icons/" + buildModeEnum.name().toLowerCase());
            buildModeIcons.put(buildModeEnum, map.func_174942_a(sprite));
        }
        for (Enum enum_ : ModeOptions.ActionEnum.values()) {
            sprite = new ResourceLocation("effortlessbuilding", "icons/" + enum_.name().toLowerCase());
            modeOptionIcons.put((ModeOptions.ActionEnum)enum_, map.func_174942_a(sprite));
        }
    }

    public static TextureAtlasSprite getBuildModeIcon(BuildModes.BuildModeEnum mode) {
        return buildModeIcons.get((Object)mode);
    }

    public static TextureAtlasSprite getModeOptionIcon(ModeOptions.ActionEnum action) {
        return modeOptionIcons.get((Object)action);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (event.phase == TickEvent.Phase.START) {
            ClientProxy.onMouseInput();
            RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
            if (objectMouseOver == null) {
                return;
            }
            if (currentLookAt == null) {
                currentLookAt = objectMouseOver;
                previousLookAt = objectMouseOver;
                return;
            }
            if (objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (ClientProxy.currentLookAt.field_72313_a != RayTraceResult.Type.BLOCK) {
                    currentLookAt = objectMouseOver;
                    previousLookAt = objectMouseOver;
                } else if (currentLookAt.func_178782_a() != objectMouseOver.func_178782_a()) {
                    previousLookAt = currentLookAt;
                    currentLookAt = objectMouseOver;
                }
            }
        } else if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.func_71410_x().field_71462_r) != null && gui.func_73868_f())) {
            ++ticksInGame;
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings((EntityPlayer)player).getBuildMode();
        if (Minecraft.func_71410_x().field_71462_r != null || buildMode == BuildModes.BuildModeEnum.NORMAL || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.field_71474_y.field_74313_G.func_151470_d()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                ItemStack currentItemStack = player.func_184586_b(EnumHand.MAIN_HAND);
                if (currentItemStack.func_77973_b() instanceof ItemBlock || CompatHelper.isItemBlockProxy(currentItemStack) && !player.func_70093_af()) {
                    ItemStack itemStack = CompatHelper.getItemBlockFromStack(currentItemStack);
                    RayTraceResult lookingAt = ClientProxy.getLookingAt((EntityPlayer)player);
                    BuildModes.onBlockPlacedMessage((EntityPlayer)player, lookingAt == null ? new BlockPlacedMessage() : new BlockPlacedMessage(lookingAt, true));
                    EffortlessBuilding.packetHandler.sendToServer((IMessage)(lookingAt == null ? new BlockPlacedMessage() : new BlockPlacedMessage(lookingAt, true)));
                    if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.BLOCK && lookingAt.field_72307_f.func_178788_d(player.func_174824_e(1.0f)).func_189985_c() > 25.0 && itemStack.func_77973_b() instanceof ItemBlock) {
                        IBlockState state = ((ItemBlock)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                        BlockPos blockPos = lookingAt.func_178782_a();
                        SoundType soundType = state.func_177230_c().getSoundType(state, player.field_70170_p, blockPos, (Entity)player);
                        player.field_70170_p.func_184133_a((EntityPlayer)player, player.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, 0.4f, soundType.func_185847_b() * 1.0f);
                        player.func_184609_a(EnumHand.MAIN_HAND);
                    }
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.field_71474_y.field_74312_F.func_151470_d()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                if (!ReachHelper.canBreakFar((EntityPlayer)player)) {
                    return;
                }
                RayTraceResult lookingAt = ClientProxy.getLookingAt((EntityPlayer)player);
                BuildModes.onBlockBrokenMessage((EntityPlayer)player, lookingAt == null ? new BlockBrokenMessage() : new BlockBrokenMessage(lookingAt));
                EffortlessBuilding.packetHandler.sendToServer((IMessage)(lookingAt == null ? new BlockBrokenMessage() : new BlockBrokenMessage(lookingAt)));
                if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.BLOCK && lookingAt.field_72307_f.func_178788_d(player.func_174824_e(1.0f)).func_189985_c() > 25.0) {
                    BlockPos blockPos = lookingAt.func_178782_a();
                    IBlockState state = player.field_70170_p.func_180495_p(blockPos);
                    SoundType soundtype = state.func_177230_c().getSoundType(state, player.field_70170_p, blockPos, (Entity)player);
                    player.field_70170_p.func_184133_a((EntityPlayer)player, player.func_180425_c(), soundtype.func_185845_c(), SoundCategory.BLOCKS, 0.4f, soundtype.func_185847_b() * 1.0f);
                    player.func_184609_a(EnumHand.MAIN_HAND);
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
        if (mc.field_71474_y.field_74312_F.func_151468_f() && RadialMenu.instance.isVisible()) {
            EffortlessBuilding.log((EntityPlayer)player, "mouse click");
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        ModeOptions.ActionEnum action;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (keyBindings[0].func_151468_f()) {
            ClientProxy.openModifierSettings();
        }
        if (keyBindings[1].func_151468_f()) {
            ModifierSettingsManager.ModifierSettings modifierSettings;
            modifierSettings.setQuickReplace(!(modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)player)).doQuickReplace());
            EffortlessBuilding.log((EntityPlayer)player, "Set " + TextFormatting.GOLD + "Quick Replace " + TextFormatting.RESET + (modifierSettings.doQuickReplace() ? "on" : "off"));
            EffortlessBuilding.packetHandler.sendToServer((IMessage)new ModifierSettingsMessage(modifierSettings));
        }
        if (keyBindings[2].func_151468_f()) {
            if (player.func_184812_l_()) {
                player.func_71165_d("/gamemode 0");
            } else {
                player.func_71165_d("/gamemode 1");
            }
        }
        if (keyBindings[4].func_151468_f()) {
            action = ModeOptions.ActionEnum.UNDO;
            ModeOptions.performAction((EntityPlayer)player, action);
            EffortlessBuilding.packetHandler.sendToServer((IMessage)new ModeActionMessage(action));
        }
        if (keyBindings[5].func_151468_f()) {
            action = ModeOptions.ActionEnum.REDO;
            ModeOptions.performAction((EntityPlayer)player, action);
            EffortlessBuilding.packetHandler.sendToServer((IMessage)new ModeActionMessage(action));
        }
        if (keyBindings[6].func_151468_f()) {
            BuildModes.BuildModeEnum currentBuildMode = ModeSettingsManager.getModeSettings((EntityPlayer)player).getBuildMode();
            if (currentBuildMode.options.length > 0) {
                ModeOptions.OptionEnum option = currentBuildMode.options[0];
                if (option.actions.length >= 2) {
                    if (ModeOptions.getOptionSetting(option) == option.actions[0]) {
                        ModeOptions.performAction((EntityPlayer)player, option.actions[1]);
                        EffortlessBuilding.packetHandler.sendToServer((IMessage)new ModeActionMessage(option.actions[1]));
                    } else {
                        ModeOptions.performAction((EntityPlayer)player, option.actions[0]);
                        EffortlessBuilding.packetHandler.sendToServer((IMessage)new ModeActionMessage(option.actions[0]));
                    }
                }
            }
        }
        if (keyBindings.length >= 8 && keyBindings[7].func_151468_f()) {
            ShaderHandler.init();
            EffortlessBuilding.log((EntityPlayer)player, "Reloaded shaders");
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        RadialMenu.instance.setVisibility(0.0f);
        if (ReachHelper.getMaxReach((EntityPlayer)player) == 0) {
            EffortlessBuilding.log((EntityPlayer)player, "Build modifiers are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
        } else if (mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)new ModifierSettingsGui());
        } else {
            player.func_71053_j();
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            BuildModes.initializeMode((EntityPlayer)player);
        }
    }

    @Nullable
    public static RayTraceResult getLookingAt(EntityPlayer player) {
        float raytraceRange = ReachHelper.getPlacementReach(player);
        return player.func_174822_a((double)raytraceRange, 1.0f);
    }

    public static void logTranslate(String key) {
        EffortlessBuilding.log((EntityPlayer)Minecraft.func_71410_x().field_71439_g, I18n.func_135052_a((String)key, (Object[])new Object[0]), true);
    }

    static {
        placeCooldown = 0;
        breakCooldown = 0;
        ticksInGame = 0;
        buildModeIcons = new HashMap();
        modeOptionIcons = new HashMap();
    }
}

