/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block;

import gregtech.api.block.UnlistedBooleanProperty;
import gregtech.api.block.VariantBlock;
import gregtech.api.util.GTUtility;
import gregtech.client.model.IModelSupplier;
import gregtech.client.model.SimpleStateMapper;
import gregtech.common.blocks.MetaBlocks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.ctm.client.state.CTMExtendedState;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class VariantActiveBlock<T extends Enum<T>>
extends VariantBlock<T>
implements IModelSupplier {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "active_blocks"), "inventory");
    public static final Object2ObjectOpenHashMap<Integer, ObjectSet<BlockPos>> ACTIVE_BLOCKS = new Object2ObjectOpenHashMap();
    private static final List<VariantActiveBlock<?>> INSTANCES = new ArrayList();
    public static final Object2ObjectOpenHashMap<Block, ObjectOpenHashSet<BlockRenderLayer>> block2blockRenderLayerMap = new Object2ObjectOpenHashMap();
    public static final PropertyBool ACTIVE_DEPRECATED = PropertyBool.func_177716_a((String)"active");
    public static final UnlistedBooleanProperty ACTIVE = new UnlistedBooleanProperty("active");

    public VariantActiveBlock(Material materialIn) {
        super(materialIn);
        INSTANCES.add(this);
    }

    @Override
    public IBlockState getState(T variant) {
        return super.getState(variant).func_177226_a((IProperty)ACTIVE_DEPRECATED, (Comparable)Boolean.valueOf(false));
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return block2blockRenderLayerMap.containsKey((Object)state.func_177230_c()) && ((ObjectOpenHashSet)block2blockRenderLayerMap.get((Object)state.func_177230_c())).contains((Object)layer);
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)ACTIVE_DEPRECATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE_DEPRECATED)).booleanValue()) {
            meta += 8;
        }
        return meta + ((Enum)((Object)state.func_177229_b((IProperty)this.VARIANT))).ordinal();
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        Class enumClass = GTUtility.getActualTypeParameter(this.getClass(), VariantActiveBlock.class, 0);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new ExtendedBlockState((Block)this, new IProperty[]{this.VARIANT, ACTIVE_DEPRECATED}, new IUnlistedProperty[]{ACTIVE});
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState ext = (IExtendedBlockState)state;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            ext = ext.withProperty((IUnlistedProperty)ACTIVE, (Object)false);
        } else {
            ACTIVE_BLOCKS.putIfAbsent((Object)Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension(), (Object)new ObjectOpenHashSet());
            ext = ext.withProperty((IUnlistedProperty)ACTIVE, (Object)((ObjectSet)ACTIVE_BLOCKS.get((Object)Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension())).contains((Object)pos));
        }
        if (Loader.isModLoaded((String)"ctm")) {
            return new CTMExtendedState((IBlockState)ext, world, pos);
        }
        return ext;
    }

    @Override
    public void onTextureStitch(TextureStitchEvent.Pre event) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new SimpleStateMapper(MODEL_LOCATION));
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), MetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBake(ModelBakeEvent event) {
        block2blockRenderLayerMap.clear();
        for (Block block : INSTANCES) {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                IBakedModel bakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation(block.getRegistryName(), MetaBlocks.statePropertiesToString(state.func_177228_b())));
                if (bakedModel == null) continue;
                block2: for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        if (bakedModel.func_188616_a(state, facing, 0L).size() <= 0) continue;
                        block2blockRenderLayerMap.putIfAbsent((Object)block, (Object)new ObjectOpenHashSet());
                        ((ObjectOpenHashSet)block2blockRenderLayerMap.get((Object)block)).add((Object)layer);
                        continue block2;
                    }
                }
            }
        }
    }
}

