/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.fluids;

import gregtech.api.GTValues;
import gregtech.api.fluids.GTFluidMaterial;
import gregtech.api.unification.material.info.MaterialFlags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class MaterialFluidBlock
extends BlockFluidClassic {
    private final gregtech.api.unification.material.Material gtMaterial;
    public final boolean isFlammable;
    public final boolean isExplosive;
    public final boolean isSticky;

    public MaterialFluidBlock(@Nonnull Fluid fluid, @Nonnull GTFluidMaterial material, @Nonnull gregtech.api.unification.material.Material gtMaterial) {
        super(fluid, (Material)material);
        this.gtMaterial = gtMaterial;
        this.isFlammable = gtMaterial.hasFlag(MaterialFlags.FLAMMABLE);
        this.isExplosive = gtMaterial.hasFlag(MaterialFlags.EXPLOSIVE);
        this.isSticky = gtMaterial.hasFlag(MaterialFlags.STICKY);
        boolean displaces = fluid.getDensity() > 1000;
        this.displacements.put(Blocks.field_150355_j, displaces);
        this.displacements.put(Blocks.field_150358_i, displaces);
        displaces = fluid.getDensity() > 3000;
        this.displacements.put(Blocks.field_150353_l, displaces);
        this.displacements.put(Blocks.field_150356_k, displaces);
    }

    @Nullable
    public Boolean isEntityInsideMaterial(@Nonnull IBlockAccess world, @Nonnull BlockPos blockpos, @Nonnull IBlockState iblockstate, @Nonnull Entity entity, double yToTest, @Nonnull Material materialIn, boolean testingHead) {
        return materialIn == Material.field_151586_h ? Boolean.valueOf(true) : null;
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable ? 5 : 0;
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable ? 200 : 0;
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        if (this.isExplosive && this.isFlammable && neighborBlock instanceof BlockFire && GTValues.RNG.nextInt(5) == 0) {
            world.func_175698_g(pos);
            world.func_72876_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 1.5f, true);
        }
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        if (this.isSticky) {
            if (entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184812_l_()) {
                return;
            }
            entityIn.field_70159_w *= 0.5;
            entityIn.field_70181_x *= 0.25;
            entityIn.field_70179_y *= 0.5;
        }
    }

    public boolean canDisplace(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (this.isFlammable && world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(@Nonnull World world, @Nonnull BlockPos pos) {
        if (this.isFlammable && world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @Nonnull
    public gregtech.api.unification.material.Material getGTMaterial() {
        return this.gtMaterial;
    }
}

