/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import com.google.gson.JsonObject;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.FileTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.resources.URLTexture;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ModifyGuiTexture
implements IGuiTexture {
    public static List<String> TYPES = Arrays.asList("resource", "url", "text", "color", "file");
    private IGuiTexture texture;

    public ModifyGuiTexture(IGuiTexture texture) {
        this.texture = texture;
        if (texture == null) {
            this.texture = new TextTexture("texture.modify_gui_texture.missing", -16777216);
        }
    }

    public IGuiTexture getTexture() {
        return this.texture;
    }

    public void setTexture(IGuiTexture texture) {
        if (texture != null) {
            this.texture = texture;
        }
    }

    public String getTypeName() {
        if (this.texture instanceof TextureArea) {
            return "resource";
        }
        if (this.texture instanceof URLTexture) {
            return "url";
        }
        if (this.texture instanceof TextTexture) {
            return "text";
        }
        if (this.texture instanceof ColorRectTexture) {
            return "color";
        }
        if (this.texture instanceof FileTexture) {
            return "file";
        }
        return null;
    }

    @Override
    public void draw(double x, double y, int width, int height) {
        this.texture.draw(x, y, width, height);
    }

    @Override
    public void updateTick() {
        this.texture.updateTick();
    }

    public JsonObject saveConfig() {
        JsonObject config = new JsonObject();
        if (this.texture instanceof TextureArea) {
            config.addProperty("type", "resource");
            config.addProperty("resource", ((TextureArea)this.texture).imageLocation.toString());
        } else if (this.texture instanceof URLTexture) {
            config.addProperty("type", "url");
            config.addProperty("url", ((URLTexture)this.texture).url);
        } else if (this.texture instanceof TextTexture) {
            config.addProperty("type", "text");
            config.addProperty("text", ((TextTexture)this.texture).text);
            config.addProperty("color", (Number)((TextTexture)this.texture).color);
        } else if (this.texture instanceof ColorRectTexture) {
            config.addProperty("type", "color");
            config.addProperty("color", (Number)((ColorRectTexture)this.texture).color);
        } else if (this.texture instanceof FileTexture) {
            config.addProperty("type", "file");
            if (((FileTexture)this.texture).file != null) {
                config.addProperty("file", ((FileTexture)this.texture).file.getPath());
            } else {
                config.addProperty("file", (String)null);
            }
        } else {
            return null;
        }
        return config;
    }

    public void loadConfig(JsonObject config) {
        try {
            switch (config.get("type").getAsString()) {
                case "resource": {
                    this.setTexture(new TextureArea(new ResourceLocation(config.get("resource").getAsString()), 0.0, 0.0, 1.0, 1.0));
                }
                case "url": {
                    this.setTexture(new URLTexture(config.get("url").getAsString()));
                }
                case "text": {
                    this.setTexture(new TextTexture(config.get("text").getAsString(), config.get("color").getAsInt()));
                }
                case "color": {
                    this.setTexture(new ColorRectTexture(config.get("color").getAsInt()));
                }
                case "file": {
                    this.setTexture(new FileTexture(new File(config.get("file").getAsString())));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

