/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;

public class SimpleTextWidget
extends Widget {
    protected final String formatLocale;
    protected final int color;
    protected final Supplier<String> textSupplier;
    protected String lastText = "";
    protected boolean isCentered = true;
    protected boolean clientWidget;
    protected boolean isShadow;
    protected float scale = 1.0f;
    protected int width;

    public SimpleTextWidget(int xPosition, int yPosition, String formatLocale, int color, Supplier<String> textSupplier) {
        this(xPosition, yPosition, formatLocale, color, textSupplier, false);
    }

    public SimpleTextWidget(int xPosition, int yPosition, String formatLocale, int color, Supplier<String> textSupplier, boolean clientWidget) {
        super(new Position(xPosition, yPosition), Size.ZERO);
        this.color = color;
        this.formatLocale = formatLocale;
        this.textSupplier = textSupplier;
        this.clientWidget = clientWidget;
    }

    public SimpleTextWidget setWidth(int width) {
        this.width = width;
        return this;
    }

    public SimpleTextWidget(int xPosition, int yPosition, String formatLocale, Supplier<String> textSupplier) {
        this(xPosition, yPosition, formatLocale, 0x404040, textSupplier, false);
    }

    public SimpleTextWidget setShadow(boolean shadow) {
        this.isShadow = shadow;
        return this;
    }

    public SimpleTextWidget setCenter(boolean isCentered) {
        this.isCentered = isCentered;
        return this;
    }

    public SimpleTextWidget setScale(float scale) {
        this.scale = scale;
        return this;
    }

    private void updateSize() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(this.lastText);
        this.setSize(new Size(stringWidth, fontRenderer.field_78288_b));
        if (this.uiAccess != null) {
            this.uiAccess.notifySizeChange();
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.clientWidget && this.textSupplier != null) {
            String newString = this.textSupplier.get();
            if (!newString.equals(this.lastText)) {
                this.lastText = newString;
                this.updateSize();
            }
            this.lastText = newString;
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        String text = this.formatLocale.isEmpty() ? (I18n.func_188566_a((String)this.lastText) ? I18n.func_135052_a((String)this.lastText, (Object[])new Object[0]) : this.lastText) : I18n.func_135052_a((String)this.formatLocale, (Object[])new Object[]{this.lastText});
        List texts = this.width > 0 ? Minecraft.func_71410_x().field_71466_p.func_78271_c(text, (int)((float)this.width * (1.0f / this.scale))) : Collections.singletonList(text);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Position pos = this.getPosition();
        float height = (float)fontRenderer.field_78288_b * this.scale * (float)texts.size();
        for (int i = 0; i < texts.size(); ++i) {
            String resultText = (String)texts.get(i);
            float width = (float)fontRenderer.func_78256_a(resultText) * this.scale;
            float x = (float)pos.x - (this.isCentered ? width / 2.0f : 0.0f);
            float y = (float)pos.y - (this.isCentered ? height / 2.0f : 0.0f) + (float)(i * fontRenderer.field_78288_b);
            SimpleTextWidget.drawText(resultText, x, y, this.scale, this.color, this.isShadow);
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (!this.textSupplier.get().equals(this.lastText)) {
            this.lastText = this.textSupplier.get();
            this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(this.lastText));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.lastText = buffer.func_150789_c(Short.MAX_VALUE);
            this.updateSize();
        }
    }
}

