/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pattern;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.BlockInfo;
import gregtech.common.blocks.MetaBlocks;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class MultiblockShapeInfo {
    private final BlockInfo[][][] blocks;

    public MultiblockShapeInfo(BlockInfo[][][] blocks) {
        this.blocks = blocks;
    }

    public BlockInfo[][][] getBlocks() {
        return this.blocks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String[]> shape = new ArrayList<String[]>();
        private Map<Character, BlockInfo> symbolMap = new HashMap<Character, BlockInfo>();

        public Builder aisle(String ... data) {
            this.shape.add(data);
            return this;
        }

        public Builder where(char symbol, BlockInfo value) {
            this.symbolMap.put(Character.valueOf(symbol), value);
            return this;
        }

        public Builder where(char symbol, IBlockState blockState) {
            return this.where(symbol, new BlockInfo(blockState));
        }

        public Builder where(char symbol, MetaTileEntity tileEntity, EnumFacing frontSide) {
            MetaTileEntityHolder holder = new MetaTileEntityHolder();
            holder.setMetaTileEntity(tileEntity);
            holder.getMetaTileEntity().onPlacement();
            holder.getMetaTileEntity().setFrontFacing(frontSide);
            return this.where(symbol, new BlockInfo(MetaBlocks.MACHINE.func_176223_P(), holder));
        }

        public Builder where(char symbol, Supplier<?> partSupplier, EnumFacing frontSideIfTE) {
            Object part = partSupplier.get();
            if (part instanceof IBlockState) {
                return this.where(symbol, (IBlockState)part);
            }
            if (part instanceof MetaTileEntity) {
                return this.where(symbol, (MetaTileEntity)part, frontSideIfTE);
            }
            throw new IllegalArgumentException("Supplier must supply either a MetaTileEntity or an IBlockState! Actual: " + part.getClass());
        }

        private BlockInfo[][][] bakeArray() {
            BlockInfo[][][] blockInfos = (BlockInfo[][][])Array.newInstance(BlockInfo.class, this.shape.get(0)[0].length(), this.shape.get(0).length, this.shape.size());
            for (int z = 0; z < blockInfos.length; ++z) {
                String[] aisleEntry = this.shape.get(z);
                for (int y = 0; y < this.shape.get(0).length; ++y) {
                    String columnEntry = aisleEntry[y];
                    for (int x = 0; x < columnEntry.length(); ++x) {
                        BlockInfo info = this.symbolMap.getOrDefault(Character.valueOf(columnEntry.charAt(x)), BlockInfo.EMPTY);
                        TileEntity tileEntity = info.getTileEntity();
                        if (tileEntity != null) {
                            MetaTileEntityHolder holder = (MetaTileEntityHolder)tileEntity;
                            MetaTileEntity mte = holder.getMetaTileEntity();
                            holder = new MetaTileEntityHolder();
                            holder.setMetaTileEntity(mte);
                            holder.getMetaTileEntity().onPlacement();
                            holder.getMetaTileEntity().setFrontFacing(mte.getFrontFacing());
                            info = new BlockInfo(info.getBlockState(), holder);
                        }
                        blockInfos[x][y][z] = info;
                    }
                }
            }
            return blockInfos;
        }

        public Builder shallowCopy() {
            Builder builder = new Builder();
            builder.shape = new ArrayList<String[]>(this.shape);
            builder.symbolMap = new HashMap<Character, BlockInfo>(this.symbolMap);
            return builder;
        }

        public MultiblockShapeInfo build() {
            return new MultiblockShapeInfo(this.bakeArray());
        }
    }
}

